using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace org.ovirt.engine.ui.uicommon.models
{
	public class ConfirmationModel : ListModel
	{
		#region Properties

		public EntityModel Latch { get; private set; }

		private string note;
		public string Note
		{
			get { return note; }
			set
			{
				if (note != value)
				{
					note = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Note"));
				}
			}
		}

		#endregion

		public ConfirmationModel()
		{
			Latch = new EntityModel();
			Latch.Entity = false;
			Latch.IsAvailable = false;
		}

		public bool Validate()
		{
			Latch.IsValid = true;
			if (Latch.IsAvailable && !(bool)Latch.Entity)
			{
				Latch.IsValid = false;
				Latch.InvalidityReasons.Add("You must approve the action by clicking on this checkbox.");
			}

			return Latch.IsValid;
		}
	}
}
