using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Text;

namespace org.ovirt.engine.ui.uicommon.models
{
	public class GuideModel : EntityModel
	{
		#region Properties

		private IList<UICommand> compulsoryActions;
		public IList<UICommand> CompulsoryActions
		{
			get { return compulsoryActions; }
			set
			{
				if (compulsoryActions != value)
				{
					compulsoryActions = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CompulsoryActions"));
				}
			}
		}

		private IList<UICommand> optionalActions;
		public IList<UICommand> OptionalActions
		{
			get { return optionalActions; }
			set
			{
				if (optionalActions != value)
				{
					optionalActions = value;
					OnPropertyChanged(new PropertyChangedEventArgs("OptionalActions"));
				}
			}
		}

		#endregion


		public GuideModel()
		{
			CompulsoryActions = new ObservableCollection<UICommand>();
			OptionalActions = new ObservableCollection<UICommand>();
		}
	}

}
