using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.validation;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;

namespace org.ovirt.engine.ui.uicommon.models.bookmarks
{
	public class BookmarkModel : Model
	{
		#region Properties

		public bool IsNew { get; set; }

		public EntityModel Name { get; set; }
		public EntityModel SearchString { get; set; }

		#endregion

		public BookmarkModel()
		{
			Name = new EntityModel();
			SearchString = new EntityModel();
		}

		internal bool Validate()
		{
			Name.ValidateEntity(new IValidation[] { new NotEmptyValidation() });

			SearchString.ValidateEntity(new IValidation[] { new NotEmptyValidation() });

			return Name.IsValid &&
				   SearchString.IsValid;
		}
	}
}
