using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.common
{
	public class SelectionTreeNodeModel : EntityModel
	{
		#region Properties

		private string description;
		public string Description
		{
			get { return description; }
			set
			{
				if (description != value)
				{
					description = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Description"));
				}
			}
		}

		private bool? isSelectedNullable;
		public bool? IsSelectedNullable
		{
			get { return isSelectedNullable; }
			set
			{
				if (isSelectedNullable == null && value == null)
					return;
				if (isSelectedNullable == null || isSelectedNullable != value)
				{
					isSelectedNullable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsSelectedNullable"));
					if (!IsSelectedNotificationPrevent)
					{
						IsSelectedChanged();
					}
				}
			}
		}

		private bool isExpanded;
		public bool IsExpanded
		{
			get { return isExpanded; }
			set
			{
				isExpanded = value;
				OnPropertyChanged(new PropertyChangedEventArgs("IsExpanded"));
			}
		}
		private bool isSelectedNotificationPrevent;
		public bool IsSelectedNotificationPrevent
		{
			get { return isSelectedNotificationPrevent; }
			set
			{
				if (isSelectedNotificationPrevent != value)
				{
					isSelectedNotificationPrevent = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsSelectedNotificationPrevent"));
				}
			}
		}

		private SelectionTreeNodeModel parent;
		public SelectionTreeNodeModel Parent
		{
			get { return parent; }
			set
			{
				if (parent != value)
				{
					parent = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Parent"));
				}
			}
		}

		private List<SelectionTreeNodeModel> children;
		public List<SelectionTreeNodeModel> Children
		{
			get { return children; }
			set
			{
				if ((children == null && value != null) || (children != null && !children.Equals(value)))
				{
					children = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Children"));
				}
			}
		}

		private string tooltip;
		public string Tooltip
		{
			get { return tooltip; }
			set
			{
				if (tooltip != value)
				{
					tooltip = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Tooltip"));
				}
			}
		}

		#endregion


		public SelectionTreeNodeModel()
		{
			Children = new List<SelectionTreeNodeModel>();
		}

		public void IsSelectedChanged()
		{
			if (Parent != null)
			{
				UpdateParentSelection();
			}
			//Children.Each(a => a.IsSelectedNotificationPrevent = true);
			//Children.Each(a => a.IsSelected = IsSelected);
			//Children.Each(a => a.IsSelectedNotificationPrevent = false);
			foreach (SelectionTreeNodeModel child in Children)
			{
				child.IsSelectedNotificationPrevent = true;
				child.IsSelectedNullable = IsSelectedNullable;
				child.IsSelectedNotificationPrevent = false;
				foreach (SelectionTreeNodeModel grandChild in child.Children)
				{
					grandChild.IsSelectedNotificationPrevent = true;
					grandChild.IsSelectedNullable = IsSelectedNullable;
					grandChild.IsSelectedNotificationPrevent = false;
				}
			}
		}

		public void UpdateParentSelection()
		{
			//            int selCount = Parent.Children.Count(a => a.IsSelected == true);
			if (Parent == null || Parent.Children == null)
				return;
			int selCount = 0, nullCount = 0;
			foreach (SelectionTreeNodeModel a in Parent.Children)
			{
				if (a.IsSelectedNullable != null && a.IsSelectedNullable == true)
				{
					selCount += 1;
				}
				else if (a.isSelectedNullable == null)
				{
					nullCount++;
				}

			}

			Parent.IsSelectedNotificationPrevent = true;
			if (selCount == 0 && nullCount == 0)
			{
				Parent.IsSelectedNullable = false;
			}
			else
			{
				//                if (Parent.Children.Count() == selCount)
				if (Parent.Children.Count == selCount)
					Parent.IsSelectedNullable = true;
				else
					Parent.IsSelectedNullable = null;
			}
			Parent.IsSelectedNotificationPrevent = false;

			Parent.UpdateParentSelection();
		}
	}
}
