using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicompat;

namespace org.ovirt.engine.ui.uicommon.models.configure
{
	public class ChangeCDModel : Model
	{
		#region Events

//		public event EventHandler Executed = delegate { };

		public static EventDefinition ExecutedEventDefinition;
		public Event ExecutedEvent { get; private set; }

		#endregion

		#region Commands

		public UICommand DoCommand { get; private set; }

		#endregion

		#region Properties

		#endregion

		static ChangeCDModel()
		{
			ExecutedEventDefinition = new EventDefinition("Executed", typeof(ChangeCDModel));
		}

		public ChangeCDModel()
		{
			ExecutedEvent = new Event(ExecutedEventDefinition);

			DoCommand = new UICommand("Do",this);
		}

		private void Do()
		{
			ExecutedEvent.raise(this, EventArgs.Empty);
//			Executed(this, EventArgs.Empty);
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == DoCommand)
			{
				Do();
			}
		}
	}
}
