using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.models.common;
using org.ovirt.engine.ui.uicompat;
using VdcCommon;

using VdcCommon.VdcQueries;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;

namespace org.ovirt.engine.ui.uicommon.models.configure
{
	public class RoleListModel : SearchableListModel
	{
		#region Commands

		public UICommand NewCommand { get; private set; }
		public UICommand EditCommand { get; private set; }
		public UICommand RemoveCommand { get; private set; }

		#endregion

		#region Properties

		public Model Window { get; private set; }

		#endregion

		public RoleListModel()
		{
			Title = "Roles";

			NewCommand = new UICommand("New", this);
			EditCommand = new UICommand("Edit", this);
			RemoveCommand = new UICommand("Remove", this);

			SearchCommand.Execute();

			UpdateActionAvailability();
		}

		protected override void SyncSearch()
		{
			base.SyncSearch();

			VdcQueryReturnValue retValue =
				Frontend.RunQuery(
				VdcQueryType.GetAllRoles,
				new MultilevelAdministrationsQueriesParameters());

			if (retValue != null && retValue.Succeeded)
			{
				//Items = ((List<IVdcQueryable>)retValue.ReturnValue).Cast<roles>().ToList();
				Items = Linq.Cast<roles>((List<IVdcQueryable>)retValue.ReturnValue);
			}

			else
			{
				Items = new List<roles>();
			}
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();

			ObservableCollection<IVdcQueryable> items;
			AsyncSearchId =
				Frontend.RegisterQuery(
					VdcQueryType.GetAllRoles,
					new MultilevelAdministrationsQueriesParameters(),
					out items);

			Items = items;
		}

		public void Remove()
		{
			ConfirmationModel model = new ConfirmationModel();
			Window = model;
			model.Title = "Remove Role(s)";
			model.Message = "Role(s):";
			//model.Items = SelectedItems.Cast<roles>().Select(a => a.name);
			model.Items = new List<string>();
			foreach (object role in SelectedItems)
			{
				((List<string>)model.Items).Add(((roles)role).name);
			}

			WindowDecorator.SetIsOpen(model, true);
			WindowDecorator.SetCommands(model,
				new List<UICommand>
			    {
			        new UICommand("OnRemove", this)
			        {
			            Title = "OK",
			            IsDefault = true
			        },
			        new UICommand("Cancel", this)
			        {
			            Title = "Cancel",
			            IsCancel = true
			        }
			    });
		}

		public void OnRemove()
		{
			List<VdcActionParametersBase> VdcActionParametersBaseList = new List<VdcActionParametersBase>();
			foreach (object rp in SelectedItems)
			{
				VdcActionParametersBaseList.Add(new RolesParameterBase(((roles)rp).id));
			}
			Frontend.RunMultipleActions(VdcActionType.RemoveRole, VdcActionParametersBaseList);

			//Frontend.RunMultipleActions(VdcActionType.RemoveRole,
			//    SelectedItems.Cast<roles>()
			//    .Select(a => (VdcActionParametersBase)new RolesParameterBase(a.id))
			//    .ToList()
			//);

			Cancel();
		}

		public void Edit()
		{
			roles role = (roles)SelectedItem;
			InitRoleDialog(role, false);
		}

		public void New()
		{
			roles role = new roles();
			InitRoleDialog(role, true);
		}

		private void InitRoleDialog(roles role, bool isNew)
		{
			RoleModel model = new RoleModel();
			Window = model;
			model.IsNew = isNew;
			model.Title = isNew ? "New Role" : "Edit Role";
			model.Name.Entity = role.name;
			model.Description.Entity = role.description;
			model.CanChangePermissions = !role.is_readonly;

			Translator objectTypeTranslator = EnumTranslator.Create<VdcObjectType>();
			Translator actionTypeTranslator = EnumTranslator.Create<VdcActionType>();

			//ManageableTypes.Init();

			List<VdcActionType> attachedActions = isNew ? new List<VdcActionType>() : DataProvider.GetRoleActionList(role.id);

			SelectionTreeNodeModel stnm;
			model.PermissionGroupModels = new List<SelectionTreeNodeModel>();
			//foreach (KeyValuePair<VdcObjectType, HashSet<VdcActionType>> kvp in ManageableTypes.ManagebleTypesPerObject)
			//{
			//    VdcObjectType key = kvp.Key;

			//    stnm = new SelectionTreeNodeModel();
			//    stnm.Title = key.ToString();
			//    stnm.Description = objectTypeTranslator[key];
			//    stnm.SetIsChangable(!role.is_readonly);

			//    stnm.Children = new List<SelectionTreeNodeModel>();
			//    foreach (VdcActionType vAct in kvp.Value)
			//    {
			//        SelectionTreeNodeModel child = new SelectionTreeNodeModel();

			//        child.Title = vAct.ToString();
			//        child.Description = actionTypeTranslator[vAct];
			//        child.IsSelectedNotificationPrevent = true;
			//        child.IsSelected = attachedActions.Contains(vAct);
			//        child.SetIsChangable(!role.is_readonly);

			//        stnm.Children.Add(child);
			//    }
			//    stnm.IsSelectedNotificationPrevent = false;
			//    model.PermissionGroupModels.Add(stnm);
			//}

			//model.PermissionGroupModels =
			//    ManageableTypes.ManagebleTypesPerObject
			//    .Select(a =>
			//        new SelectionTreeNodeModel
			//        {
			//            Title = a.Key.ToString(),
			//            Description = objectTypeTranslator[a.Key],
			//            IsChangeAllowed = !role.is_readonly,
			//            Children = a.Value.Select(b =>
			//                new SelectionTreeNodeModel
			//                {
			//                    Title = b.ToString(),
			//                    Description = actionTypeTranslator[b],                                
			//                    IsSelectedNotificationPrevent = true,
			//                    IsSelected = attachedActions.Contains(b),
			//                    IsChangeAllowed = !role.is_readonly
			//                }

			//            )
			//            .ToList(),                        
			//            IsSelectedNotificationPrevent = false
			//        }
			//    )
			//    .ToList();

			foreach (SelectionTreeNodeModel sm in model.PermissionGroupModels)
			{
				foreach (SelectionTreeNodeModel smChild in sm.Children)
				{
					smChild.Parent = sm;
					smChild.IsSelectedNotificationPrevent = false;

					if (sm.Children[0].Equals(smChild)) { smChild.UpdateParentSelection(); }
				}

				//TODO: Convert OrderBy
				//sm.Children = (List<SelectionTreeNodeModel>)UI.Common.Linq.OrderBy<SelectionTreeNodeModel, string>
				//    (sm.Children, delegate(SelectionTreeNodeModel s) { return s.Description; });
			}

			//model.PermissionGroupModels.Each(a => a.Children.Each(b => { b.Parent = a; b.IsSelectedNotificationPrevent = false; }));
			//model.PermissionGroupModels.Each(a => { if (a.Children.Count > 0) { a.Children[0].UpdateParentSelection(); } });
			//model.PermissionGroupModels.Each(a => a.Children.Sort(b=>b.Description));

			WindowDecorator.SetIsOpen(model, true);
			List<UICommand> commands = new List<UICommand>();

			if (!role.is_readonly)
			{
				commands.Add(
					new UICommand("OnSave", this)
					{
						Title = "OK",
						IsDefault = true
					});
				commands.Add(
					new UICommand("OnReset", this)
					{
						Title = "Reset",
					});
			}

			commands.Add(
				new UICommand("Cancel", this)
				{
					Title = !role.is_readonly ? "Cancel" : "Close",
					IsCancel = true,
					IsDefault = role.is_readonly
				});

			WindowDecorator.SetCommands(model, commands);

		}
		public void OnReset()
		{
			roles role = (roles)SelectedItem;
			RoleModel model = (RoleModel)Window;

			List<VdcActionType> attachedActions = model.IsNew ? new List<VdcActionType>() : DataProvider.GetRoleActionList(role.id);

			//model.PermissionGroupModels.SelectMany(a => a.Children).Each(a=>a.IsSelected = attachedActions.Contains((VdcActionType)Enum.Parse(typeof(VdcActionType),a.Title)));
			foreach (SelectionTreeNodeModel sm in model.PermissionGroupModels)
			{
				foreach (SelectionTreeNodeModel smChild in sm.Children)
				{
					smChild.IsSelected = attachedActions.Contains((VdcActionType)Enum.Parse(typeof(VdcActionType), sm.Title));
				}
			}
		}

		public void OnSave()
		{
			RoleModel model = (RoleModel)Window;
			roles role = model.IsNew ? new roles() : (roles)SelectedItem;

			if (!model.Validate())
			{
				return;
			}
			string name = (string)model.Name.Entity;
			//Check name unicitate.
			if (!DataProvider.IsRoleNameUnique(name) && String.Compare(name, role.name, true) != 0)
			{
				model.Name.SetIsValid(false);
				model.Name.GetInvalidityReasons().Add("Name must be unique.");
				return;
			}


			role.name = (string)model.Name.Entity;
			role.description = (string)model.Description.Entity;

			//var actions = model.PermissionGroupModels
			//    .SelectMany(a => a.Children)
			//    .Where(a => a.IsSelected.Value == true)
			//    .Select(a => (VdcActionType)Enum.Parse(typeof(VdcActionType), a.Title))
			//    .ToList();

			List<VdcActionType> actions = new List<VdcActionType>();
			foreach (SelectionTreeNodeModel sm in model.PermissionGroupModels)
			{
				foreach (SelectionTreeNodeModel smChild in sm.Children)
				{
					if (smChild.IsSelected.Value)
					{
						actions.Add((VdcActionType)Enum.Parse(typeof(VdcActionType), smChild.Title));
					}
				}
			}

			VdcReturnValueBase returnValue = null;

			if (model.IsNew)
			{
				//Add a new role. 
				// *** TODO: AddRoleWithActions doesn't exist anymore! Should be replaced with AddRoleWithActionGroups
				//returnValue = Frontend.RunAction(VdcActionType.AddRoleWithActions,
				//    new RoleWithMultipleActionsParameters(role, actions));
			}
			else
			{
				//Update an existing role.
				returnValue = Frontend.RunAction(VdcActionType.UpdateRole,
					new RolesOperationsParameters(role));

				//Frontend.RunMultipleActions(VdcActionType.AttachActionToRole,
				//    actions.Except(attachedActions)
				//    .Select(a => (VdcActionParametersBase)new RolesActionMapParameters(new roles_actions(a, role.id)))
				//    .ToList()
				//);
				List<VdcActionParametersBase> vaList = new List<VdcActionParametersBase>();

				// *** TODO: Replace 'foreach' of 'AttachActionToRole' with 'AttachActionGroupsToRole' ****
				// ALSO: Replace 'foreach' of 'DetachActionFromRole' with 'DetachActionGroupsFromRole'.
				//foreach (VdcActionType vat in Linq.Except(actions,DataProvider.GetRoleActionList(role.id)))
				//{
				//    vaList.Add(new RolesActionMapParameters(new roles_actions(vat, role.id)));
				//}
				
				//Frontend.RunMultipleActions(VdcActionType.AttachActionToRole, vaList);
				

				////var attachedActions = DataProvider.GetRoleActionList(role.id);
				////Frontend.RunMultipleActions(VdcActionType.DetachActionFromRole,
				////    attachedActions.Except(actions)
				////    .Select(a => (VdcActionParametersBase)new RolesActionMapParameters(new roles_actions(a, role.id)))
				////    .ToList()
				////);
				
				//vaList.Clear();
				//foreach (VdcActionType vat in Linq.Except(DataProvider.GetRoleActionList(role.id),actions))
				//{
				//    vaList.Add(new RolesActionMapParameters(new roles_actions(vat, role.id)));
				//}
				//Frontend.RunMultipleActions(VdcActionType.DetachActionFromRole, vaList);
				// *****************************************************************************************
				
			}

			if (returnValue != null && returnValue.Succeeded)
			{
				Cancel();
			}
		}

		public void Cancel()
		{
			if (Window != null)
			{
				WindowDecorator.SetIsOpen(Window, false);
				Window = null;
			}
		}

		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();
			UpdateActionAvailability();
		}

		protected override void SelectedItemsChanged()
		{
			base.SelectedItemsChanged();
			UpdateActionAvailability();
		}

		private void UpdateActionAvailability()
		{
			EditCommand.IsExecutionAllowed = SelectedItems != null && SelectedItems.Count == 1;
			//RemoveCommand.IsExecutionAllowed = SelectedItems != null && SelectedItems.Count > 0 && 
			//    SelectedItems.Cast<roles>().FirstOrDefault(a=>a.is_readonly) == null;

			RemoveCommand.IsExecutionAllowed = SelectedItems != null && SelectedItems.Count > 0 && !IsAnyRoleReadOnly(SelectedItems);
		}

		private bool IsAnyRoleReadOnly(IList roles)
		{
			foreach (object item in roles)
			{
				roles r = (roles)item;
				if (r.is_readonly)
				{
					return true;
				}
			}
			return false;
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == NewCommand)
			{
				New();
			}
			else if (command == EditCommand)
			{
				Edit();
			}
			else if (command == RemoveCommand)
			{
				Remove();
			}
			else if (command.Name == "OnSave")
			{
				OnSave();
			}
			else if (command.Name == "Cancel")
			{
				Cancel();
			}
			else if (command.Name == "OnRemove")
			{
				OnRemove();
			}
			else if (command.Name == "OnReset")
			{
				OnReset();
			}
		}
	}
}
