﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using System.Collections.ObjectModel;

namespace org.ovirt.engine.ui.uicommon.models.configure.roles_ui
{
	public class RolePermissionListModel : SearchableListModel
	{
		#region Commands

		public UICommand RemoveCommand { get; private set; }

		#endregion

		#region Properties

		public new roles Entity
		{
			get { return (roles)base.Entity; }
			set { base.Entity = value; }
		}

		private Model window;
		public Model Window
		{
			get { return window; }
			set
			{
				if (window != value)
				{
					window = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Window"));
				}
			}
		}

		#endregion

		public RolePermissionListModel()
		{
			Title = "Role's Permissions";

			RemoveCommand = new UICommand("Remove", this);

			SearchCommand.Execute();

			UpdateActionAvailability();
		}

		protected override void SyncSearch()
		{
			base.SyncSearch();

			VdcQueryReturnValue retValue =
				Frontend.RunQuery(
				VdcQueryType.GetPermissionByRoleId,
				new MultilevelAdministrationByRoleIdParameters(Entity.Id));

			if (retValue != null && retValue.Succeeded)
			{
				//Items = ((List<IVdcQueryable>)retValue.ReturnValue).Cast<roles>().ToList();
				Items = Linq.Cast<permissions>((List<permissions>)retValue.ReturnValue);
			}

			else
			{
				Items = new List<roles>();
			}
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();
			AsyncSearch();
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();

			if (Entity == null)
			{
				return;
			}

			AsyncResult = Frontend.RegisterQuery(VdcQueryType.GetPermissionByRoleId, new MultilevelAdministrationByRoleIdParameters(Entity.Id));
			Items = AsyncResult.Data;
		}

		private void UpdateActionAvailability()
		{
			RemoveCommand.IsExecutionAllowed = SelectedItem != null
				|| (SelectedItems != null && SelectedItems.Count > 0);

		}

		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();
			UpdateActionAvailability();
		}

		protected override void SelectedItemsChanged()
		{
			base.SelectedItemsChanged();
			UpdateActionAvailability();
		}

		public void Cancel()
		{
			Window = null;
		}

		private void Remove()
		{
			if (Window != null)
			{
				return;
			}

			ConfirmationModel model = new ConfirmationModel();
			Window = model;
			model.Title = "Remove Permission";
			model.HashName = "remove_permission";
			model.Message = "Permission";
			
			List<string> items = new List<string>();
			foreach (object a in SelectedItems)
			{
				items.Add("Role " + ((permissions)a).RoleName + " on User " + ((permissions)a).OwnerName);
			}
			model.Items = items;

			model.Commands.Add(
				new UICommand("OnRemove", this)
				{
					Title = "OK",
					IsDefault = true
				});
			model.Commands.Add(
				new UICommand("Cancel", this)
				{
					Title = "Cancel",
					IsCancel = true
				});
		}

		private void OnRemove()
		{
			if (SelectedItems != null && SelectedItems.Count > 0)
			{
				ConfirmationModel model = (ConfirmationModel)Window;

				if (model.Progress != null)
				{
					return;
				}

				List<VdcActionParametersBase> list = new List<VdcActionParametersBase>();
				foreach (object perm in SelectedItems)
				{
					list.Add(new PermissionsOperationsParametes { Permission = (permissions)perm });
				}


				model.StartProgress(null);

				Frontend.RunMultipleAction(VdcActionType.RemovePermission, list,
					result =>
					{
						ConfirmationModel localModel = (ConfirmationModel)result.State;

						localModel.StopProgress();
						Cancel();
					},
					model
				);
			}
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == RemoveCommand)
			{
				Remove();
			}
			else if (command.Name == "OnRemove")
			{
				OnRemove();
			}
			else if (command.Name == "Cancel")
			{
				Cancel();
			}
		}
	}
}
