using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.models.events;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using VdcCommon.VdcQueries;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.hosts
{
	public class HostEventListModel : EventListModel
	{
		#region Properties

		public new VDS Entity
		{
			get { return (VDS)base.Entity; }
			set { base.Entity = value; }
		}

		#endregion

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			if (Entity != null)
			{
				SearchCommand.Execute();
			}
			else
			{
				Items = null;
			}
		}

		public override void Search()
		{
			if (Entity != null)
			{
				SearchString = String.Format("events: host.name={0}", Entity.vds_name);
				base.Search();
			}
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			if (e.PropertyName == "vds_name")
			{
				SearchCommand.Execute();
			}
		}
	}
}
