﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using org.ovirt.engine.ui.uicommon.dataprovider;
using org.ovirt.engine.ui.uicommon.models;
using VdcCommon.BusinessEntities;
using VdcFrontend;

namespace org.ovirt.engine.ui.uicommon.models.pools
{
	public class PoolDiskListModel : SearchableListModel
	{
		public PoolDiskListModel()
		{
			Title = "Virtual Disks";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			vm_pools pool = (vm_pools)Entity;
			if (pool != null)
			{
				AsyncQuery _asyncQuery = new AsyncQuery();
				_asyncQuery.Model = this;
				/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object result)
				                            	{
													VM vm = (VM)result;
													if (vm != null)
													{
														PoolDiskListModel poolDiskListModel = (PoolDiskListModel)model;
														poolDiskListModel.SyncSearch(VdcQueryType.GetAllDisksByVmId, new GetAllDisksByVmIdParameters(vm.vm_guid));
													}
												};//END_DELEGATE
				AsyncDataProvider.GetAnyVm(_asyncQuery, pool.vm_pool_name);
			}
		}
	}
}
