﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using VdcCommon.BusinessEntities;
using VdcFrontend;

namespace org.ovirt.engine.ui.uicommon.models.resources
{
	public class ResourcesModel : SearchableListModel
	{
		#region Properties

		public EntityModel DefinedVMs { get; private set; }
		public EntityModel RunningVMs { get; private set; }
		public EntityModel RunningVMsPercentage { get; private set; }
		public EntityModel DefinedCPUs { get; private set; }
		public EntityModel UsedCPUs { get; private set; }
		public EntityModel UsedCPUsPercentage { get; private set; }
		public EntityModel DefinedMemory { get; private set; }
		public EntityModel UsedMemory { get; private set; }
		public EntityModel UsedMemoryPercentage { get; private set; }
		public EntityModel TotalDisksSize { get; private set; }
		public EntityModel NumOfSnapshots { get; private set; }
		public EntityModel TotalSnapshotsSize { get; private set; }
		
		#endregion

		public ResourcesModel()
		{
			DefinedVMs = new EntityModel();
			RunningVMs = new EntityModel();
			RunningVMsPercentage = new EntityModel();
			DefinedCPUs = new EntityModel();
			UsedCPUs = new EntityModel();
			UsedCPUsPercentage = new EntityModel();
			DefinedMemory = new EntityModel();
			UsedMemory = new EntityModel();
			UsedMemoryPercentage = new EntityModel();
			TotalDisksSize = new EntityModel();
			NumOfSnapshots = new EntityModel();
			TotalSnapshotsSize = new EntityModel();
		}

		protected override void SyncSearch()
		{
			base.SyncSearch();
			
			AsyncQuery _asyncQuery = new AsyncQuery();
			_asyncQuery.Model = this;
			/*START_DELEGATE*/_asyncQuery.asyncCallback = delegate(Object model, Object ReturnValue)
			{
				ResourcesModel resourcesModel = (ResourcesModel)model;
				List<VM> list = (List<VM>)((VdcQueryReturnValue)ReturnValue).ReturnValue;
				//TODO: Insert dummy data regarding disks and snapshots.
				foreach (VM vm in list)
				{
					//vm.DiskList =
					//    new[]
					//    {
					//        new DiskImage
					//        {
					//            internal_drive_mapping = "1",
					//            SizeInGigabytes = 100,
					//            ActualSize = 50,
					//Snapshots =
					//    new[]
					//    {
					//        new DiskImage(),
					//        new DiskImage()
					//    }
					//},
					//new DiskImage
					//{
					//    internal_drive_mapping = "2",
					//    SizeInGigabytes = 200,
					//    ActualSize = 80,
					//Snapshots =
					//    new[]
					//    {
					//        new DiskImage(),
					//        new DiskImage(),
					//        new DiskImage()
					//    }
					//    }
					//};
				}


				//Update calculated properties.
				int runningVMs = 0;
				int definedCPUs = 0;
				int usedCPUs = 0;
				int definedMemory = 0;
				int usedMemory = 0;
				long totalDisksSize = 0;
				long totalSnapshotsSize = 0;
				int numOfSnapshots = 0;

				foreach (VM vm in list)
				{
					definedCPUs += vm.num_of_cpus;
					definedMemory += vm.vm_mem_size_mb;

					if (vm.isStatusUp())
					{
						runningVMs++;
						usedCPUs += vm.num_of_cpus;
						usedMemory += vm.vm_mem_size_mb;
					}

					if (vm.DiskList != null)
					{
						foreach (DiskImage disk in vm.DiskList)
						{
							totalDisksSize += disk.SizeInGigabytes;
							totalSnapshotsSize += (long)disk.ActualDiskWithSnapshotsSize;
							numOfSnapshots += disk.Snapshots.Length;
						}
					}
				}

				DefinedVMs.Entity = list.Count;
				RunningVMs.Entity = runningVMs;
				RunningVMsPercentage.Entity = runningVMs * 100 / list.Count;
				DefinedCPUs.Entity = definedCPUs;
				UsedCPUs.Entity = usedCPUs;
				UsedCPUsPercentage.Entity = usedCPUs * 100 / definedCPUs;
				DefinedMemory.Entity = SizeParser(definedMemory);
				UsedMemory.Entity = SizeParser(usedMemory);
				UsedMemoryPercentage.Entity = usedMemory * 100 / definedMemory;
				TotalDisksSize.Entity = totalDisksSize >= 1 ? totalDisksSize + "GB" : "<1GB";
				TotalSnapshotsSize.Entity = totalSnapshotsSize >= 1 ? totalSnapshotsSize + "GB" : "<1GB";
				NumOfSnapshots.Entity = numOfSnapshots;

				resourcesModel.Items = list;
			};//END_DELEGATE


			//Items property will contain list of VMs.
			GetUserVmsByUserIdAndGroupsParameters getUserVmsByUserIdAndGroupsParameters = 
				new GetUserVmsByUserIdAndGroupsParameters(Frontend.LoggedInUser.UserId);
			getUserVmsByUserIdAndGroupsParameters.IncludeDiskData = true;
			Frontend.RunQuery(VdcQueryType.GetUserVmsByUserIdAndGroups, getUserVmsByUserIdAndGroupsParameters, _asyncQuery);
		}

		// Temporarily converter
		// TODO: Use converters infrastructure in UICommon
		public string SizeParser(long sizeInMb)
		{
			return ((sizeInMb >= 1024 && sizeInMb % 1024 == 0) ? (sizeInMb / 1024 + "GB") : (sizeInMb + "MB"));
		}

	}
}
