using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using VdcCommon.BusinessEntities;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.storage
{
	public class StorageGeneralModel : EntityModel
	{
		#region Properties

		private bool isNfs;
		public bool IsNfs
		{
			get { return isNfs; }
			set
			{
				if (isNfs != value)
				{
					isNfs = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsNfs"));
				}
			}
		}

		private bool isLocalS;
		public bool IsLocalS
		{
			get { return isLocalS; }
			set
			{
				if (isLocalS != value)
				{
					isLocalS = value;
					OnPropertyChanged(new PropertyChangedEventArgs("IsLocalS"));
				}
			}
		}

		private string nfsPath;
		public string NfsPath
		{
			get { return nfsPath; }
			set
			{
				if (nfsPath != value)
				{
					nfsPath = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NfsPath"));
				}
			}
		}

		private string localPath;
		public string LocalPath
		{
			get { return localPath; }
			set
			{
				if (localPath != value)
				{
					localPath = value;
					OnPropertyChanged(new PropertyChangedEventArgs("LocalPath"));
				}
			}
		}

		#endregion


		public StorageGeneralModel()
		{
			Title = "General";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			if (Entity != null)
			{
				storage_domains storageDomain = (storage_domains)Entity;

				IsNfs = storageDomain.storage_type == StorageType.NFS;
				IsLocalS = storageDomain.storage_type == StorageType.LOCALFS;
				if (IsNfs || IsLocalS)
				{
                    storage_server_connections connection = DataProvider.GetStorageConnectionById(storageDomain.storage);
					string path = null;
					if(connection != null)
                    {
                        path = connection.connection;
                    }
                    else
                    {
                        nfsPath = null;
                    	LocalPath = null;
                    }
					if(IsNfs)
					{
						NfsPath = path;
					}
					else
					{
						LocalPath = path;
					}
				}
				else
				{
					NfsPath = null;
					LocalPath = null;
				}
				
			}
		}
	}
}
