using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.validation;

namespace org.ovirt.engine.ui.uicommon.models.tags
{
	public class TagModel : Model
	{
		#region Events

		public static EventDefinition SelectionChangedEventDefinition;
		public Event SelectionChangedEvent { get; private set; }

		#endregion

		#region Static Recursive Functions

		public static void RecursiveEditAttachDetachLists(TagModel tagModel, IDictionary<Guid, bool> attachedEntities, List<Guid> tagsToAttach, List<Guid> tagsToDetach)
		{
			if (tagModel.Selection != null && tagModel.Selection == true && (!attachedEntities.ContainsKey(tagModel.Id) || attachedEntities[tagModel.Id] == false))
			{
				tagsToAttach.Add(tagModel.Id);
			}
			else if (tagModel.Selection != null && tagModel.Selection == false && attachedEntities.ContainsKey(tagModel.Id))
			{
				tagsToDetach.Add(tagModel.Id);
			}
			if (tagModel.Children != null)
			{
				foreach (TagModel subModel in tagModel.Children)
				{
					RecursiveEditAttachDetachLists(subModel, attachedEntities, tagsToAttach, tagsToDetach);
				}
			}
		}
		#endregion


		#region Properties

		public bool IsNew { get; set; }
		public Guid Id { get; set; }
		public Guid ParentId { get; set; }
		public List<TagModel> Children { get; set; }

		public EntityModel Name { get; set; }
		public EntityModel Description { get; set; }

		private bool? selection;
		public bool? Selection
		{
			get { return selection; }
			set
			{
				if (selection == null && value == null)
					return;
				if (selection == null || selection != value)
				{
					selection = value;
					SelectionChangedEvent.raise(this, EventArgs.Empty);
					OnPropertyChanged(new PropertyChangedEventArgs("Selection"));
				}
			}
		}

		private TagModelType type;
		public TagModelType Type
		{
			get { return type; }
			set
			{
				if (type != value)
				{
					type = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Type"));
				}
			}
		}

		#endregion

		static TagModel()
		{
			SelectionChangedEventDefinition = new EventDefinition("SelectionChanged", typeof(TagModel));
		}

		public TagModel()
		{
			SelectionChangedEvent = new Event(SelectionChangedEventDefinition);

			Name = new EntityModel();
			Description = new EntityModel();
		}

		internal bool Validate()
		{
			Name.ValidateEntity(new IValidation[] { new NotEmptyValidation(), new RegexValidation { Expression = "^[A-Za-z0-9_-]+$", Message = "Name can contain only 'A-Z', 'a-z', '0-9', '_' or '-' characters." } });

			return Name.IsValid;
		}
	}


	public enum TagModelType
	{
		Regular,
		ReadOnly,
		Root
	}
}
