using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using VdcCommon.Interfaces;
using VdcCommon.VdcQueries;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using System.ComponentModel;
using System.Collections;

namespace org.ovirt.engine.ui.uicommon.models.templates
{
	public class TemplateDiskListModel : SearchableListModel
	{
		#region Properties

		private VmTemplate EntityStronglyTyped
		{
			get { return base.Entity as VmTemplate; }
		}

		#endregion

		public TemplateDiskListModel()
		{
			Title = "Virtual Disks";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();
			SearchCommand.Execute();
		}

		public override void Search()
		{
			if (EntityStronglyTyped != null)
			{
				base.Search();
			}
		}

		protected override void SyncSearch()
		{
			base.SyncSearch(VdcQueryType.GetVmTemplatesDisks, new GetVmTemplatesDisksParameters(EntityStronglyTyped.Id));
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();

			AsyncResult = Frontend.RegisterQuery(VdcQueryType.GetVmTemplatesDisks, new GetVmTemplatesDisksParameters(EntityStronglyTyped.Id));
			Items = AsyncResult.Data;
		}
	}
}
