using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.models.vms;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using System.Collections;

namespace org.ovirt.engine.ui.uicommon.models.templates
{
	public class TemplateVmListModel : VmListModel
	{
        #region Properties

        public new VmTemplate Entity
        {
            get { return base.Entity as VmTemplate; }
            set { base.Entity = value; }
        }

        #endregion


        public TemplateVmListModel()
		{
			Title = "Virtual Machines";
		}

        protected override void OnEntityChanged()
        {
            base.OnEntityChanged();
            SearchCommand.Execute();
        }

        public override void Search()
        {
            if (Entity != null)
            {
                SearchString = String.Format("Vms: template.name={0}", Entity.name);
                base.Search();
            }
        }
	}
}
