using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.models.configure;
using org.ovirt.engine.ui.uicommon.models.tags;
using VdcCommon;
using VdcCommon.Users;
using VdcCommon.VdcQueries;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.users
{
	public class UserListModel : ListWithDetailsModel
	{
		public static Guid EveryoneUserId = new Guid("eee00000-0000-0000-0000-123456789eee");

		#region Commands

		public UICommand AddCommand { get; private set; }
		public UICommand RemoveCommand { get; private set; }
		public UICommand AssignTagsCommand { get; private set; }

		#endregion

		#region Properties

		private Model window;
		public Model Window
		{
			get { return window; }
			set
			{
				if (window != value)
				{
					window = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Window"));
				}
			}
		}

		protected object[] SelectedKeys
		{
			//			get { return SelectedItems == null ? new object[0] : SelectedItems.Cast<DbUser>().Select(a => a.user_id).Cast<object>().ToArray(); }
			get
			{
				if (SelectedItems == null)
				{
					return new object[0];
				}
				else
				{
					List<object> items = new List<object>();
					foreach (object i in SelectedItems)
					{
						items.Add(((VDSGroup)i).ID);
					}
					return items.ToArray();
				}
			}
		}
		#endregion


		public UserListModel()
		{
			Title = "Users";

			DefaultSearchString = "Users:";
			SearchString = DefaultSearchString;

			AddCommand = new UICommand("Add", this);
			RemoveCommand = new UICommand("Remove", this);
			AssignTagsCommand = new UICommand("AssignTags", this);

			UpdateActionAvailability();

			SearchNextPageCommand.IsAvailable = true;
			SearchPreviousPageCommand.IsAvailable = true;
		}

		public void AssignTags()
		{
			if (Window != null)
			{
				return;
			}

			TagListModel model = new TagListModel();
			Window = model;
			model.Title = "Assign Tags";
			model.HashName  = "assign_tags_users";

			model.AttachedTagsToEntities = GetAttachedTagsToSelectedUsers();
			List<TagModel> tags = (List<TagModel>)model.Items;

			model.Commands.Add(
				new UICommand("OnAssignTags", this)
				{
					Title = "OK",
					IsDefault = true
				});
			model.Commands.Add(
				new UICommand("Cancel", this)
				{
					Title = "Cancel",
					IsCancel = true
				});
		}

		private Dictionary<Guid, bool> GetAttachedTagsToSelectedUsers()
		{
			Dictionary<Guid, bool> tags = new Dictionary<Guid, bool>();

			//			List<guid> userIds = SelectedItems
			//				.Cast<DbUser>()
			//				.Select(a => a.user_id)
			//				.ToList();

			List<guid> userIds = new List<guid>();
			List<guid> grpIds = new List<guid>();

			foreach (object item in SelectedItems)
			{
				DbUser user = (DbUser)item;
				if (!user.IsGroup)
				{
					userIds.Add(user.user_id);
				}
				else
				{
					grpIds.Add(user.user_id);
				}
			}

			//			List<DbUser> allAttachedTags = userIds.SelectMany(a => DataProvider.GetAttachedTagsToUser(a)).ToList();

			//			List<DbUser> attachedTags = allAttachedTags
			//				.Distinct(new TagsEqualityComparer())
			//				.ToList();

			List<VdcCommon.BusinessEntities.tags> allAttachedTags = new List<VdcCommon.BusinessEntities.tags>();

			foreach (guid userId in userIds)
			{
				allAttachedTags.AddRange(DataProvider.GetAttachedTagsToUser(userId));
			}
			foreach (guid grpId in grpIds)
			{
				allAttachedTags.AddRange(DataProvider.GetAttachedTagsToUserGroup(grpId));
			}

			List<VdcCommon.BusinessEntities.tags> attachedTags = (List<VdcCommon.BusinessEntities.tags>)Linq.Distinct(allAttachedTags, new TagsEqualityComparer());

			//attachedTags.Each(a => { tags.Add(a.tag_id, allAttachedTags.Count(b => b.tag_id == a.tag_id) == userIds.Count() ? true : false); });
			foreach (VdcCommon.BusinessEntities.tags a in attachedTags)
			{
				int count = 0;
				foreach (VdcCommon.BusinessEntities.tags b in allAttachedTags)
				{
					if (b.tag_id.Equals(a.tag_id))
					{
						count++;
					}
				}

				tags.Add(a.tag_id, count == userIds.Count + grpIds.Count);
			}

			return tags;
		}

		private void OnAssignTags()
		{
			TagListModel model = (TagListModel)Window;

			//			List<DbUser> userIds = SelectedItems
			//				.Cast<DbUser>()
			//				.Select(a => a.user_id)
			//				.ToList();

			List<Guid> userIds = new List<Guid>();
			List<Guid> grpIds = new List<Guid>();

			foreach (object item in SelectedItems)
			{
				DbUser user = (DbUser)item;
				if (user.IsGroup)
				{
					grpIds.Add(user.user_id);
				}
				else
				{
					userIds.Add(user.user_id);
				}
			}

			Dictionary<Guid, bool> attachedTags = GetAttachedTagsToSelectedUsers();

			//prepare attach/detach lists
			List<Guid> tagsToAttach = new List<Guid>();
			List<Guid> tagsToDetach = new List<Guid>();

			//model.Items
			//     .Cast<TagModel>()
			//     .First()
			//     .EachRecursive(a => a.Children, (a, b) =>
			//     {
			//         if (a.Selection == true && (!attachedTags.ContainsKey(a.Id) || attachedTags[a.Id] == false))
			//         {
			//             tagsToAttach.Add(a.Id);
			//         }
			//         else if (a.Selection == false && attachedTags.ContainsKey(a.Id))
			//         {
			//             tagsToDetach.Add(a.Id);
			//         }
			//     });

			if (model.Items != null && ((List<TagModel>)model.Items).Count > 0)
			{
				List<TagModel> tags = (List<TagModel>)model.Items;
				TagModel rootTag = tags[0];
				TagModel.RecursiveEditAttachDetachLists(rootTag, attachedTags, tagsToAttach, tagsToDetach);
			}

			List<VdcActionParametersBase> usersToAttach = new List<VdcActionParametersBase>();
			List<VdcActionParametersBase> grpsToAttach = new List<VdcActionParametersBase>();
			foreach (Guid tag_id in tagsToAttach)
			{
				if (userIds.Count > 0)
				{
					usersToAttach.Add(new AttachEntityToTagParameters(tag_id, userIds));
				}
				if (grpIds.Count > 0)
				{
					grpsToAttach.Add(new AttachEntityToTagParameters(tag_id, grpIds));
				}
			}
			if (usersToAttach.Count > 0)
			{
				Frontend.RunMultipleAction(VdcActionType.AttachUserToTag, usersToAttach);
			}
			if (grpsToAttach.Count > 0)
			{
				Frontend.RunMultipleAction(VdcActionType.AttachUserGroupToTag, grpsToAttach);
			}
			//			Frontend.RunMultipleActions(VdcActionType.AttachUserToTag,
			//				tagsToAttach.Select(a =>
			//                  (VdcActionParametersBase)new AttachEntityToTagParameters(a, userIds.Select(userId => (Guid)userId).ToList())
			//			)
			//			.ToList()
			//		);

			//			Frontend.RunMultipleActions(VdcActionType.DetachUserFromTag,
			//				tagsToDetach.Select(a =>
			//                  (VdcActionParametersBase)new AttachEntityToTagParameters(a, userIds.Select(userId => (Guid)userId).ToList())
			//			)
			//			.ToList()
			//		);

			List<VdcActionParametersBase> usersToDetach = new List<VdcActionParametersBase>();
			List<VdcActionParametersBase> grpsToDetach = new List<VdcActionParametersBase>();
			foreach (Guid tag_id in tagsToDetach)
			{
				if (userIds.Count > 0)
				{
					usersToDetach.Add(new AttachEntityToTagParameters(tag_id, userIds));
				}
				if (grpIds.Count > 0)
				{
					grpsToDetach.Add(new AttachEntityToTagParameters(tag_id, grpIds));
				}
			}
			if (usersToDetach.Count > 0)
			{
				Frontend.RunMultipleAction(VdcActionType.DetachUserFromTag, usersToDetach);
			}
			if (grpsToDetach.Count > 0)
			{
				Frontend.RunMultipleAction(VdcActionType.DetachUserGroupFromTag, grpsToDetach);
			}

			Cancel();
		}

		public void Add()
		{
			if (Window != null)
			{
				return;
			}

			AdElementListModel model = new AdElementListModel();
			Window = model;
			model.Title = "Add Users and Groups";
			model.HashName = "add_users_and_groups";
			model.ExcludeItems = DataProvider.GetUserList();
			model.IsRoleListHidden = true;


			model.Commands.Add(
				new UICommand("OnAdd", this)
				{
					Title = "OK",
					IsDefault = true
				});
			model.Commands.Add(
				new UICommand("Cancel", this)
				{
					Title = "Cancel",
					IsCancel = true
				});
		}

		public void Remove()
		{
			if (Window != null)
			{
				return;
			}

			ConfirmationModel model = new ConfirmationModel();
			Window = model;
			model.Title = "Remove User(s)";
			model.HashName = "remove_user";
			model.Message = "User(s)";

			List<string> list = new List<string>();
			foreach (DbUser item in Linq.Cast<DbUser>(SelectedItems))
			{
				list.Add(item.name);
			}
			model.Items = list;


			model.Commands.Add(
				new UICommand("OnRemove", this)
				{
					Title = "OK",
					IsDefault = true
				});
			model.Commands.Add(
				new UICommand("Cancel", this)
				{
					Title = "Cancel",
					IsCancel = true
				});
		}

		public override bool IsSearchStringMatch(string searchString)
		{
			return searchString.Trim().ToLower().StartsWith("user");
		}

		protected override void SyncSearch()
		{
			base.SyncSearch(VdcQueryType.Search, new SearchParameters(SearchString, SearchType.DBUser)
			{
				MaxCount = SearchPageSize
			});
		}

		private EntityModel userGroupListModel;
		private EntityModel userEventNotifierListModel;

		protected override void InitDetailModels()
		{
			base.InitDetailModels();

			ObservableCollection<EntityModel> list = new ObservableCollection<EntityModel>();
			list.Add(new UserGeneralModel());
			list.Add(new UserPermissionListModel());
			list.Add(new UserEventListModel());
			userGroupListModel = new UserGroupListModel();
			userGroupListModel.IsAvailable = false;
			list.Add(userGroupListModel);
			userEventNotifierListModel = new UserEventNotifierListModel();
			list.Add(userEventNotifierListModel);
			DetailModels = list;
		}

		protected override void UpdateDetailsAvailability()
		{
			if (SelectedItem != null)
			{
				DbUser adUser = (DbUser)SelectedItem;
				userGroupListModel.IsAvailable = !adUser.IsGroup;
				userEventNotifierListModel.IsAvailable = !adUser.IsGroup;
			}
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();

			AsyncResult = Frontend.RegisterSearch(SearchString, SearchType.DBUser, SearchPageSize);
			Items = AsyncResult.Data;
		}

		public void Cancel()
		{
			Window = null;
		}

		public void OnAdd()
		{
			AdElementListModel model = (AdElementListModel)Window;

			if (model.Progress != null)
			{
				return;
			}

			if (model.SelectedItems == null)
			{
				Cancel();
				return;
			}

			
			List<DbUser> items = new List<DbUser>();
			foreach (object item in model.Items)
			{
				EntityModel entityModel = (EntityModel)item;
				if (entityModel.IsSelected)
				{
					items.Add((DbUser)entityModel.Entity);
				}
			}

			List<VdcActionParametersBase> parameters = new List<VdcActionParametersBase>();
			foreach (DbUser item in items)
			{
				if (!item.IsGroup)
				{
					parameters.Add(new AddUserParameters { VdcUser = new VdcUser(item.user_id, item.username, item.domain) });
				}
				else
				{
					parameters.Add(new AddUserParameters { AdGroup = new ad_groups(item.user_id, item.name, item.domain) });
				}
			}


			model.StartProgress(null);

			Frontend.RunMultipleAction(VdcActionType.AddUser, parameters,
				result =>
				{
					AdElementListModel localModel = (AdElementListModel)result.State;

					localModel.StopProgress();
					Cancel();
				},
				model
			);
		}

		public void OnRemove()
		{
			List<DbUser> items = Linq.Cast<DbUser>(SelectedItems);

			List<VdcActionParametersBase> userPrms = new List<VdcActionParametersBase>();
			List<VdcActionParametersBase> groupPrms = new List<VdcActionParametersBase>();
			foreach (DbUser item in items)
			{
				if (!item.IsGroup)
				{
					userPrms.Add(new AdElementParametersBase(item.user_id));
				}
				else
				{
					groupPrms.Add(new AdElementParametersBase(item.user_id));
				}
			}

			if (userPrms.Count > 0)
			{
				Frontend.RunMultipleAction(VdcActionType.RemoveUser, userPrms);

			}

			if (groupPrms.Count > 0)
			{
				Frontend.RunMultipleAction(VdcActionType.RemoveAdGroup, groupPrms);
			}

			Cancel();
		}

		//private void AssignTags()
		//{
		//    base.AssignTags();

		//    DbUser user = (DbUser)SelectedItem;
		//    AssignTagsModel.AttachedTags = DataProvider.GetAttachedTagsToUser(user.user_id);
		//}

		//public override void NotifyTagsAttached(IList<tags> tags)
		//{
		//    base.NotifyTagsAttached(tags);

		//    var dbUsers = SelectedItems.Cast<DbUser>();

		//    var userIds = dbUsers
		//        .Where(a => !a.IsGroup)
		//        .Select(a => a.user_id)
		//        .ToList();

		//    Frontend.RunMultipleActions(VdcActionType.AttachUserToTag,
		//        tags.Select(a =>
		//            (VdcActionParametersBase)new AttachEntityToTagParameters(a.tag_id, userIds)
		//        )
		//        .ToList()
		//    );

		//    var groupIds = dbUsers
		//        .Where(a => a.IsGroup)
		//        .Select(a => a.user_id)
		//        .ToList();

		//    Frontend.RunMultipleActions(VdcActionType.AttachUserGroupToTag,
		//        tags.Select(a =>
		//            (VdcActionParametersBase)new AttachEntityToTagParameters(a.tag_id, groupIds)
		//        )
		//        .ToList()
		//    );
		//}

		//public override void NotifyTagsDetached(IList<tags> tags)
		//{
		//    base.NotifyTagsDetached(tags);

		//    var dbUsers = SelectedItems.Cast<DbUser>();

		//    var userIds = dbUsers
		//        .Where(a => !a.IsGroup)
		//        .Select(a => a.user_id)
		//        .ToList();

		//    Frontend.RunMultipleActions(VdcActionType.DetachUserFromTag,
		//        tags.Select(a =>
		//            (VdcActionParametersBase)new AttachEntityToTagParameters(a.tag_id, userIds)
		//        )
		//        .ToList()
		//    );

		//    var groupIds = dbUsers
		//        .Where(a => a.IsGroup)
		//        .Select(a => a.user_id)
		//        .ToList();

		//    Frontend.RunMultipleActions(VdcActionType.DetachUserGroupFromTag,
		//        tags.Select(a =>
		//            (VdcActionParametersBase)new AttachEntityToTagParameters(a.tag_id, groupIds)
		//        )
		//        .ToList()
		//    );
		//}

		//public override void OnSelectionChanged(object item, IList items)
		//{
		//    base.OnSelectionChanged(item, items);

		//    UpdateActionAvailability();
		//}


		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();
			UpdateActionAvailability();
		}

		protected override void SelectedItemsChanged()
		{
			base.SelectedItemsChanged();
			UpdateActionAvailability();
		}

		private void UpdateActionAvailability()
		{
			ArrayList items = (ArrayList)SelectedItems ?? new ArrayList();

			RemoveCommand.IsExecutionAllowed = items.Count > 0
				&& VdcActionUtils.CanExecute(items, typeof(DbUser), VdcActionType.RemoveUser);

			AssignTagsCommand.IsExecutionAllowed = items.Count > 0;
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == AddCommand)
			{
				Add();
			}
			if (command == RemoveCommand)
			{
				Remove();
			}
			if (command == AssignTagsCommand)
			{
				AssignTags();
			}

			if (command.Name == "Cancel")
			{
				Cancel();
			}
			if (command.Name == "OnAssignTags")
			{
				OnAssignTags();
			}
			if (command.Name == "OnAdd")
			{
				OnAdd();
			}

			if (command.Name == "OnRemove")
			{
				OnRemove();
			}
		}
	}
}
