using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using System.ComponentModel;
using System.Collections.ObjectModel;

namespace org.ovirt.engine.ui.uicommon.models.users
{
	public class UserPermissionListModel : SearchableListModel
	{
		#region Commands

		public UICommand RemoveCommand { get; private set; }

		#endregion

		#region Properties

		private Model window;
		public Model Window
		{
			get { return window; }
			set
			{
				if (window != value)
				{
					window = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Window"));
				}
			}
		}

		public new DbUser Entity
		{
			get { return base.Entity as DbUser; }
			set { base.Entity = value; }
		}

		#endregion

		public UserPermissionListModel()
		{
			Title = "Permissions";

			RemoveCommand = new UICommand("Remove", this);

			UpdateActionAvailability();
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();
			SearchCommand.Execute();
		}

		public override void Search()
		{
			if (Entity != null)
			{
				base.Search();
			}
		}

		protected override void AsyncSearch()
		{
			base.AsyncSearch();

			AsyncResult = Frontend.RegisterQuery(VdcQueryType.GetPermissionsByAdElementId, new MultilevelAdministrationByAdElementIdParameters(Entity.user_id));
			Items = AsyncResult.Data;
		}

		public void Remove()
		{
			if (Window != null)
			{
				return;
			}

			ConfirmationModel model = new ConfirmationModel();
			Window = model;
			model.Title = "Remove Permission";
			model.HashName = "remove_permission";
			model.Message = "Permission";

			List<string> list = new List<string>();
			foreach (permissions a in Linq.Cast<permissions>(SelectedItems))
			{
				list.Add("Role " + a.RoleName + " on User " + a.OwnerName);
			}
			model.Items = list;


			model.Commands.Add(
				new UICommand("OnRemove", this)
				{
					Title = "OK",
					IsDefault = true
				});
			model.Commands.Add(
				new UICommand("Cancel", this)
				{
					Title = "Cancel",
					IsCancel = true
				});
		}

		private void OnRemove()
		{
			if (SelectedItems != null && SelectedItems.Count > 0)
			{
				ConfirmationModel model = (ConfirmationModel)Window;

				if (model.Progress != null)
				{
					return;
				}

				List<VdcActionParametersBase> list = new List<VdcActionParametersBase>();
				foreach (object perm in SelectedItems)
				{
					list.Add(new PermissionsOperationsParametes { Permission = (permissions)perm });
				}


				model.StartProgress(null);

				Frontend.RunMultipleAction(VdcActionType.RemovePermission, list,
					result =>
					{
						ConfirmationModel localModel = (ConfirmationModel)result.State;

						localModel.StopProgress();
						Cancel();
					},
					model
				);
			}
			else
			{
				Cancel();
			}
		}

		public void Cancel()
		{
			Window = null;
		}

		protected override void OnSelectedItemChanged()
		{
			base.OnSelectedItemChanged();
			UpdateActionAvailability();
		}

		protected override void SelectedItemsChanged()
		{
			base.SelectedItemsChanged();
			UpdateActionAvailability();
		}

		private void UpdateActionAvailability()
		{
			RemoveCommand.IsExecutionAllowed = SelectedItem != null
				|| (SelectedItems != null && SelectedItems.Count > 0);
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == RemoveCommand)
			{
				Remove();
			}
			if (command.Name == "OnRemove")
			{
				OnRemove();
			}
			if (command.Name == "Cancel")
			{
				Cancel();
			}
		}
	}
}
