using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.validation;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class ExportVmModel : Model
	{
		#region Properties

		public ListModel Storage { get; private set; }
		public EntityModel CollapseSnapshots { get; private set; }
		public EntityModel ForceOverride { get; private set; }

		#endregion

		public ExportVmModel()
		{
			Storage = new ListModel();

			CollapseSnapshots = new EntityModel();
			CollapseSnapshots.Entity = false;

			ForceOverride = new EntityModel();
			ForceOverride.Entity = false;
		}

		internal bool Validate()
		{
			Storage.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			return Storage.IsValid;
		}
	}
}
