using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Text;
using System.Windows;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class VmAppListModel : ListModel
	{
		public VmAppListModel()
		{
			Title = "Applications";
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);
			if (e.PropertyName == "app_list")
			{
				UpdateAppList();
			}
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			//Deal with pool as Entity without failing.
			if (!(Entity is vm_pools))
			{
				UpdateAppList();
			}
		}

		private void UpdateAppList()
		{
			VM vm = (VM)Entity;

			//Items = (Entity != null && Entity.app_list != null)
			//    ? Entity.app_list.Split(',').OrderBy(a => a)
			//    : null;

			Items = null;
			if (vm != null && vm.app_list != null)
			{
				List<string> list = new List<string>();

				string[] array = vm.app_list.Split(',');
				foreach (string item in array)
				{
					list.Add(item);
				}
				list.Sort();

				Items = list;
			}
		}
	}
}
