using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicommon.models.events;
using org.ovirt.engine.ui.uicompat;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using VdcFrontend;
using VdcCommon.VdcQueries;
using System.Collections;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.vms
{
	public class VmEventListModel : EventListModel
	{
		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			//Deal with pool as Entity without failing.
			if (Entity != null && !(Entity is vm_pools))
			{
				SearchCommand.Execute();
			}
			else
			{
				Items = null;
			}
		}

		public override void Search()
		{
			VM vm = (VM)Entity;

			if (Entity != null)
			{
				SearchString = "events: vm.name=" + vm.vm_name;
				base.Search();
			}
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			if (e.PropertyName == "vm_name")
			{
				SearchCommand.Execute();
			}
		}
	}
}
