﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.ServiceModel.Security;
using System.Windows;
using System.Windows.Data;
using System.Globalization;
using System.Collections;
using System.Windows.Interop;
using System.Windows.Threading;
using VdcCommon.VdcQueries;
using VdcCommon.BusinessEntities;
using System.Windows.Media;
using VdcFrontend;
using System.ServiceModel.Configuration;
using System.IO;
using System.Linq;
using System.Windows.Controls;

using VdcCommon;

using System.Runtime.InteropServices;

namespace UI.WPFClient
{
	public partial class App
	{
		#region Properties

		public static string Host
		{
			get
			{
				return !BrowserInteropHelper.Source.IsFile
					? BrowserInteropHelper.Source.Host
					: "localhost";
			}
		}

		public static int Port
		{
			get
			{
				return !BrowserInteropHelper.Source.IsFile
					? BrowserInteropHelper.Source.Port
					: 80;
			}
		}

		public static string Scheme
		{
			get
			{
				return !BrowserInteropHelper.Source.IsFile
					? BrowserInteropHelper.Source.Scheme
					: "file";
			}
		}

		private static string relativePath;
		public static string RelativePath
		{
			get
			{
				if (String.IsNullOrEmpty(relativePath))
				{
					string path = BrowserInteropHelper.Source.AbsoluteUri;
					relativePath = path.Remove(path.LastIndexOf('/') + 1);
				}

				return relativePath;
			}
		}

		#endregion

		protected override void OnStartup(StartupEventArgs e)
		{
			base.OnStartup(e);

			MainWindow.Title = "Red Hat Enterprise Virtualization Manager";
		}

		private void App_OnDispatcherUnhandledException(object sender, DispatcherUnhandledExceptionEventArgs e)
		{
			if (e.Exception is COMException)
			{
				e.Handled = true;
			}
		}
	}
}
