using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Threading;
using System.Windows.Data;
using System.Windows;
using System.Windows.Markup;
using Microsoft.Practices.Unity;
using VdcCommon;
using log4net.Util.TypeConverters;
using org.ovirt.engine.ui.uicommon;
using System.Text.RegularExpressions;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicommon.models.datacenters;
using org.ovirt.engine.ui.uicommon.models.clusters;
using org.ovirt.engine.ui.uicommon.models.hosts;
using org.ovirt.engine.ui.uicommon.models.vms;
using org.ovirt.engine.ui.uicommon.models.templates;
using org.ovirt.engine.ui.uicommon.models.users;
using org.ovirt.engine.ui.uicommon.models.storage;
using org.ovirt.engine.ui.uicommon.models.pools;
using org.ovirt.engine.ui.uicommon.models.events;
using org.ovirt.engine.ui.uicommon.models.monitor;
using org.ovirt.engine.ui.uicommon.models.configure;
using org.ovirt.engine.ui.uicommon.models.bookmarks;
using org.ovirt.engine.ui.uicommon.models.tags;
using org.ovirt.engine.ui.uicompat;
using org.ovirt.engine.ui.uicommon.models.configure.roles_ui;
using System.Diagnostics;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon.models.common;
using System.Windows.Media;
using System.Windows.Controls;
using System.Collections;

namespace UI.WPFClient
{
	public class ModelToViewConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value == null)
				return null;


			Type t = value.GetType();

			if (t == typeof(LoginModel))
			{
				return TypeResolver.Instance.Resolve<LoginView>();
			}
			if (t == typeof(CommonModel))
			{
				return TypeResolver.Instance.Resolve<CommonView>();
			}


			if (t == typeof(DataCenterListModel))
			{
				return TypeResolver.Instance.Resolve<DataCenterListView>();
			}
			if (t == typeof(DataCenterClusterListModel))
			{
				return TypeResolver.Instance.Resolve<DataCenterClusterListView>();
			}
			if (t == typeof(DataCenterStorageListModel))
			{
				return TypeResolver.Instance.Resolve<DataCenterStorageListView>();
			}
			if (t == typeof(DataCenterEventListModel))
			{
				return TypeResolver.Instance.Resolve<EventShortListView>();
			}
			if (t == typeof(DataCenterNetworkListModel))
			{
				return TypeResolver.Instance.Resolve<DataCenterNetworkListView>();
			}


			if (t == typeof(ClusterListModel))
			{
				return TypeResolver.Instance.Resolve<ClusterListView>();
			}
			if (t == typeof(ClusterPolicyModel))
			{
				return TypeResolver.Instance.Resolve<ClusterPolicyView>();
			}
			if (t == typeof(ClusterHostListModel))
			{
				return TypeResolver.Instance.Resolve<ClusterHostListView>();
			}
			if (t == typeof(ClusterVmListModel))
			{
				return TypeResolver.Instance.Resolve<ClusterVmListView>();
			}
			if (t == typeof(ClusterNetworkListModel))
			{
				return TypeResolver.Instance.Resolve<ClusterNetworkListView>();
			}


			if (t == typeof(HostListModel))
			{
				return TypeResolver.Instance.Resolve<HostListView>();
			}
			if (t == typeof(HostVmListModel))
			{
				return TypeResolver.Instance.Resolve<HostVmListView>();
			}
			if (t == typeof(HostEventListModel))
			{
				return TypeResolver.Instance.Resolve<EventShortListView>();
			}
			if (t == typeof(HostGeneralModel))
			{
				return TypeResolver.Instance.Resolve<HostGeneralView>();
			}
			if (t == typeof(HostInterfaceListModel))
			{
				return TypeResolver.Instance.Resolve<HostInterfaceListView>();
			}


			if (t == typeof(VmListModel))
			{
				return TypeResolver.Instance.Resolve<VmListView>();
			}
			if (t == typeof(VmGeneralModel))
			{
				return TypeResolver.Instance.Resolve<VmGeneralView>();
			}
			if (t == typeof(VmDiskListModel))
			{
				return TypeResolver.Instance.Resolve<VmDiskListView>();
			}
			if (t == typeof(VmSnapshotListModel))
			{
				return TypeResolver.Instance.Resolve<VmSnapshotListView>();
			}
			if (t == typeof(VmAppListModel))
			{
				return TypeResolver.Instance.Resolve<VmAppListView>();
			}
			if (t == typeof(VmEventListModel))
			{
				return TypeResolver.Instance.Resolve<EventShortListView>();
			}
			if (t == typeof(VmInterfaceListModel))
			{
				return TypeResolver.Instance.Resolve<VmInterfaceListView>();
			}


			if (t == typeof(TemplateListModel))
			{
				return TypeResolver.Instance.Resolve<TemplateListView>();
			}
			if (t == typeof(TemplateGeneralModel))
			{
				return TypeResolver.Instance.Resolve<TemplateGeneralView>();
			}
			if (t == typeof(TemplateDiskListModel))
			{
				return TypeResolver.Instance.Resolve<TemplateDiskListView>();
			}
			if (t == typeof(TemplateEventListModel))
			{
				return TypeResolver.Instance.Resolve<EventShortListView>();
			}
			if (t == typeof(TemplateVmListModel))
			{
				return TypeResolver.Instance.Resolve<TemplateVmListView>();
			}
			if (t == typeof(TemplateInterfaceListModel))
			{
				return TypeResolver.Instance.Resolve<TemplateInterfaceListView>();
			}
			if (t == typeof(TemplateStorageListModel))
			{
				return TypeResolver.Instance.Resolve<TemplateStorageListView>();
			}


			if (t == typeof(UserListModel))
			{
				return TypeResolver.Instance.Resolve<UserListView>();
			}
			if (t == typeof(UserGeneralModel))
			{
				return TypeResolver.Instance.Resolve<UserGeneralView>();
			}
			if (t == typeof(UserPermissionListModel))
			{
				return TypeResolver.Instance.Resolve<UserPermissionListView>();
			}
			if (t == typeof(UserVmListModel))
			{
				return TypeResolver.Instance.Resolve<UserVmListView>();
			}
			if (t == typeof(UserEventListModel))
			{
				return TypeResolver.Instance.Resolve<EventShortListView>();
			}
			if (t == typeof(UserGroupListModel))
			{
				return TypeResolver.Instance.Resolve<UserGroupListView>();
			}
			if (t == typeof(UserEventNotifierListModel))
			{
				return TypeResolver.Instance.Resolve<UserEventNotifierListView>();
			}


			if (t == typeof(StorageListModel))
			{
				return TypeResolver.Instance.Resolve<StorageListView>();
			}
			if (t == typeof(StorageEventListModel))
			{
				return TypeResolver.Instance.Resolve<EventShortListView>();
			}
			if (t == typeof(StorageGeneralModel))
			{
				return TypeResolver.Instance.Resolve<StorageGeneralView>();
			}
			if (t == typeof(StorageVmListModel))
			{
				return TypeResolver.Instance.Resolve<StorageVmListView>();
			}
			if (t == typeof(StorageTemplateListModel))
			{
				return TypeResolver.Instance.Resolve<StorageTemplateListView>();
			}
			if (t == typeof(StorageDataCenterListModel))
			{
				return TypeResolver.Instance.Resolve<StorageDataCenterListView>();
			}
			if (t == typeof(StorageIsoListModel))
			{
				return TypeResolver.Instance.Resolve<StorageIsoListView>();
			}
			if (t == typeof(StorageModel))
			{
				return TypeResolver.Instance.Resolve<StorageView>();
			}
			if (t == typeof(NfsStorageModel))
			{
				return TypeResolver.Instance.Resolve<NfsStorageView>();
			}
			if (t == typeof(FcpStorageModel))
			{
				return TypeResolver.Instance.Resolve<FcpStorageView>();
			}
			if (t == typeof(IscsiStorageModel))
			{
				return TypeResolver.Instance.Resolve<IscsiStorageView>();
			}
			if (t == typeof(LocalStorageModel))
			{
				return TypeResolver.Instance.Resolve<LocalStorageView>();
			}
			if (t == typeof(IscsiImportStorageModel))
			{
				return TypeResolver.Instance.Resolve<IscsiImportStorageView>();
			}
			if (t == typeof(FcpImportStorageModel))
			{
				return TypeResolver.Instance.Resolve<FcpImportStorageView>();
			}


			if (t == typeof(VmBackupModel))
			{
				return TypeResolver.Instance.Resolve<VmBackupView>();
			}
			if (t == typeof(TemplateBackupModel))
			{
				return TypeResolver.Instance.Resolve<TemplateBackupView>();
			}


			if (t == typeof(PoolListModel))
			{
				return TypeResolver.Instance.Resolve<PoolListView>();
			}
			if (t == typeof(PoolGeneralModel))
			{
				return TypeResolver.Instance.Resolve<PoolGeneralView>();
			}
			if (t == typeof(PoolVmListModel))
			{
				return TypeResolver.Instance.Resolve<PoolVmListView>();
			}
			if (t == typeof(EventListModel))
			{
				return TypeResolver.Instance.Resolve<EventListView>();
			}


			if (t == typeof(MonitorModel))
			{
				return TypeResolver.Instance.Resolve<MonitorView>();
			}
			if (t == typeof(RoleListModel))
			{
				return TypeResolver.Instance.Resolve<RoleListView>();
			}
			if (t == typeof(BookmarkListModel))
			{
				return TypeResolver.Instance.Resolve<BookmarkListView>();
			}
			if (t == typeof(TagListModel))
			{
				return TypeResolver.Instance.Resolve<TagListView>();
			}
			if (t == typeof(SystemTreeModel))
			{
				return TypeResolver.Instance.Resolve<SystemTreeView>();
			}
			if (t == typeof(PermissionListModel))
			{
				return TypeResolver.Instance.Resolve<PermissionListView>();
			}
			if (t == typeof(RolePermissionListModel))
			{
				return TypeResolver.Instance.Resolve<RolePermissionListView>();
			}
			if (t == typeof(SystemPermissionListModel))
			{
				return TypeResolver.Instance.Resolve<SystemPermissionListView>();
			}
			if (t == typeof(HostHooksListModel))
			{
				return TypeResolver.Instance.Resolve<HostHooksListView>();
			}
			if (t == typeof(VmImportInterfaceListModel))
			{
				return TypeResolver.Instance.Resolve<VmInterfaceImportListView>();
			}
			if (t == typeof(VmImportDiskListModel))
			{
				return TypeResolver.Instance.Resolve<VmDiskImportListView>();
			}
			if (t == typeof(TemplateImportDiskListModel))
			{
				return TypeResolver.Instance.Resolve<TemplateDiskImportListView>();
			}
			if (t == typeof(TemplateImportInterfaceListModel))
			{
				return TypeResolver.Instance.Resolve<TemplateInterfaceImportListView>();
			}

			return null;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}

		#endregion
	}

	public class ModelToViewImportConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value == null)
				return null;


			Type t = value.GetType();

			if (t == typeof(VmGeneralModel))
			{
				return TypeResolver.Instance.Resolve<VmGeneralImportView>();
			}

			if (t == typeof(VmImportDiskListModel))
			{
				return TypeResolver.Instance.Resolve<VmDiskImportListView>();
			}
			if (t == typeof(VmAppListModel))
			{
				return TypeResolver.Instance.Resolve<VmAppListView>();
			}

			if (t == typeof(VmImportInterfaceListModel))
			{
				return TypeResolver.Instance.Resolve<VmInterfaceImportListView>();
			}

			if (t == typeof(TemplateGeneralModel))
			{
				return TypeResolver.Instance.Resolve<TemplateGeneralImportView>();
			}

			if (t == typeof(TemplateImportInterfaceListModel))
			{
				return TypeResolver.Instance.Resolve<TemplateInterfaceImportListView>();
			}
			if (t == typeof(TemplateImportDiskListModel))
			{
				return TypeResolver.Instance.Resolve<TemplateDiskImportListView>();
			}


			return null;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}
		#endregion
	}

	public class NullToVisibleConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return value == null ? Visibility.Collapsed : Visibility.Visible;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}

		#endregion
	}


	public class NullToBooleanConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return value == null;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}

		#endregion
	}


	public class NegativeBooleanConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value == null)
				return false;
			return !(bool)value;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return !(bool)value;
		}

		#endregion
	}


	public class NullableValueConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return value;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return value is String && String.IsNullOrEmpty((string)value)
				? null
				: value;
		}

		#endregion
	}


	public class FriendlyVersionConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			var version = value as Version;
			if (version != null)
			{
				return org.ovirt.engine.ui.uicommon.Extensions.GetFriendlyVersion(version);
			}

			return null;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}

		#endregion
	}


	public class UptimeToStringConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			double seconds = System.Convert.ToDouble(value);
			TimeSpan ts = TimeSpan.FromSeconds(seconds);

			if (ts.Days > 0)
			{
				return string.Format("{0} {1}", ts.Days, (ts.Days == 1 ? "day" : "days"));
			}
			if (ts.Hours > 0)
			{
				return ts.Hours + " h";
			}
			if (ts.Minutes > 0)
			{
				return ts.Minutes + " min";
			}
			if (ts.Seconds > 0)
			{
				return "< 1 min";
			}

			return String.Empty;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}


	public class ObjectEqualityToVisibilityConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value == null)
				return Visibility.Hidden;

			return value.Equals(parameter) ? Visibility.Visible : Visibility.Hidden;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}


	public class ObjectEqualityConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value == null)
				return false;

			return value.Equals(parameter);
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value == null || (bool)value == false)
				return null;

			return parameter;
		}

		#endregion
	}


	public class HostLoadConverter : IMultiValueConverter
	{
		private static readonly int vcpuConsumption;

		static HostLoadConverter()
		{
			vcpuConsumption = DataProvider.GetVcpuConsumptionPercentage();
		}

		#region IMultiValueConverter Members

		public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
		{
			int vmCpus = System.Convert.ToInt32(values[0]);
			int vmCount = System.Convert.ToInt32(values[1]);
			int hostCpus = System.Convert.ToInt32(values[2]);

			return
				new
				{
					Min = 0.0,
					Max = 100.0,
					Value = 100.0 / ((Math.Max(1, hostCpus) * 100.0 / vcpuConsumption) / vmCpus),
					VmCount = vmCount
				};
		}

		public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public class RxTxRateConverter : IMultiValueConverter
	{
		#region IMultiValueConverter Members

		public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
		{
			if (values[0] == null || values[1] == null)
			{
				return "[N/A]";
			}

			double x_rate = System.Convert.ToDouble(values[0]);
			double speed = System.Convert.ToDouble(values[1]);

			double calc = x_rate * speed / 100;

			if (calc < 1 && calc >= 0)
			{
				return "< 1";
			}
			else if (calc > 0)
			{
				int retVal = (int)calc;
				return retVal.ToString();
			}
			return "0";
		}

		public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public class SumUpMultiConverter : IMultiValueConverter
	{
		#region IMultiValueConverter Members

		public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
		{
			double sum = 0;
			for (int i = 0; i < values.Length; i++)
			{
				if (values[i] == null)
				{
					return "[N/A]";
				}
				sum += System.Convert.ToDouble(values[i]);
			}
			int intVal = (int)sum;
			return intVal.ToString();
		}

		public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}


	public class TranslateToStringConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value != null)
			{
				object key = null;
				Translator translator = null;

				if (value is Enum)
				{
					key = value;
					translator = EnumTranslator.Create(value.GetType());
				}
				else if (value is int)
				{
					Type type = (Type)parameter;
					key = Enum.ToObject(type, (int)value);
					translator = EnumTranslator.Create(type);
				}
				else if (value is String)
				{
					Type type = (Type)parameter;
					if (type.IsEnum)
					{
						key = Enum.Parse(type, value.ToString());
						translator = EnumTranslator.Create(type);
					}
					else
					{
						key = value;
						translator = StringTranslator.Create(type);
					}
				}

				return translator.ContainsKey(key) ? translator[key] : key;
			}

			return null;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}



	public class FallStep
	{
		public int Value { get; set; }
		public object Output { get; set; }
	}

	public class FallWithinConverter : IValueConverter
	{
		public List<FallStep> Steps { get; set; }


		public FallWithinConverter()
		{
			Steps = new List<FallStep>();
		}

		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			int v = System.Convert.ToInt32(value);

			for (int i = 0; i < Steps.Count; i++)
			{
				var step = Steps[i];
				int from = i == 0 ? int.MinValue : Steps[i - 1].Value;
				int to = i == Steps.Count - 1 ? int.MaxValue : step.Value;

				if (v < to && v >= from)
				{
					return step.Output;
				}
			}

			return null;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public class MemSizeToStringConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			//Assume we get memory size in MB.

			string formatString;
			int memSize = System.Convert.ToInt32(value);
			if (memSize >= 1024 && Decimal.Remainder(memSize, 1024) == 0)
			{
				memSize /= 1024;
				formatString = "{0} GB";
			}
			else
			{
				formatString = "{0} MB";
			}

			return String.Format(formatString, memSize);
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			var groups = Regex.Match((string)value, @"^\s*(\d+)\s*(m|mb|g|gb){0,1}\s*$", RegexOptions.IgnoreCase).Groups;

			int number = 0;
			int size = 0;
			if (int.TryParse(groups[1].Value, out number))
			{
				if (groups.Count > 1)
				{
					string unit = groups[2].Value.ToLower();
					size = number * (unit == "g" || unit == "gb" ? 1024 : 1);
				}
			}
			return size;
		}

		#endregion
	}

	public class HighAvailabilityToStringConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			int highPriority = DataProvider.GetMaxVmPriority();
			int roundedPriority = DataProvider.RoundPriority((int)value);

			if (roundedPriority == 1)
			{
				return "Low";
			}
			else if (roundedPriority == DataProvider.GetMaxVmPriority() / 2)
			{
				return "Medium";
			}
			else if (roundedPriority == DataProvider.GetMaxVmPriority())
			{
				return "High";
			}
			else
			{
				return "Unknown";
			}
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public class BooleanToStringConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value != null)
			{
				switch ((string)parameter)
				{
					case "ActiveInactive":
						return (bool)value ? "Active" : "Inactive";
					case "TrueFalse":
						return (bool)value ? "True" : "False";
					case "YesNo":
						return (bool)value ? "Yes" : "No";
					default:
						return (bool)value ? "True" : "False";
				}
			}
			else
			{
				return "[N/A]";
			}
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public class MultiplyValueConverter : IValueConverter
	{
		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value != null && value is int)
			{
				double multiplyBy = System.Convert.ToDouble(parameter);
				int intValue = (int)value;

				return intValue * multiplyBy;
			}

			return null;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}
	}

	public sealed class GridLengthConverter : IValueConverter
	{
		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			double dLength = (double)value;

			return new GridLength(dLength);
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			GridLength gLength = (GridLength)value;

			return gLength.Value;
		}
	}

	public sealed class DoubleToIntegerConverter : IValueConverter
	{
		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return System.Convert.ToDouble(value);
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return System.Convert.ToInt32(value);
		}
	}

	public sealed class ObjectNameWithTypeConverter : IValueConverter
	{
		private readonly Translator translator;

		public ObjectNameWithTypeConverter()
		{
			translator = EnumTranslator.Create<VdcObjectType>();
		}

		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			permissions perm = (permissions)value;
			if (perm.ObjectType == VdcObjectType.System)
				return "(" + translator[perm.ObjectType] + ")";
			return perm.ObjectName + " (" + translator[perm.ObjectType] + ")";
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public sealed class ObjectNameInPermissionConverter : IMultiValueConverter
	{
		#region IMultiValueConverter Members

		private Translator translator;
		public ObjectNameInPermissionConverter()
		{
			translator = EnumTranslator.Create<VdcObjectType>();
		}

		public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
		{
			if (DataProvider.GetEntityGuid(values[0]).Equals((guid)values[1]))
				return "";

			string objectName = (string)values[2];

			VdcObjectType vdcObjectType = (VdcObjectType)values[3];
			string objectType = translator[vdcObjectType];
			if (vdcObjectType == VdcObjectType.System)
				return "(" + objectType + ")";
			return objectName + " (" + objectType + ")";
		}

		public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public sealed class GroupNameInPermissionConverter : IMultiValueConverter
	{
		#region IMultiValueConverter Members

		public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
		{
			if (DataProvider.GetEntityGuid(values[0]).Equals((guid)values[1]))
				return "";

			return values[2];
		}

		public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public sealed class ActionGroupForegroundConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			List<SelectionTreeNodeModel> tree = (List<SelectionTreeNodeModel>)value;
			if (tree.Count > 0)
				return Colors.Gray;
			return Colors.Black;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public sealed class THPCompatibilityVersionConverter : IValueConverter
	{
		#region IValueConverter Members

		object IValueConverter.Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			bool retVal = false;
			if (value != null)
			{
				Version version = (Version)value;
				int val = version.CompareTo(new Version("3.0"));
				if (val >= 0)
					retVal = true;
				else retVal = false;
			}
			return retVal;
		}

		object IValueConverter.ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public sealed class LowerThan3_0CompatibilityVersionConverter : IValueConverter
	{
		#region IValueConverter Members

		object IValueConverter.Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value != null)
			{
				Version version = (Version)value;
				int val = version.CompareTo(new Version("3.0"));
				if (val < 0)
					return Visibility.Visible;
				return Visibility.Collapsed;
			}

			return Visibility.Collapsed;
		}

		object IValueConverter.ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public class InterfaceBondNameConverter : IMultiValueConverter
	{
		#region IMultiValueConverter Members

		object IMultiValueConverter.Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
		{
			string name = (string)values[0];
			string bondName = (string)values[1];
			if (bondName != null)
			{
				return name + " (Bond: " + bondName + ")";
			}
			return name;
		}

		object[] IMultiValueConverter.ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public class ColumnVisibilityWidthConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value is VM)
				return 0.0;
			return double.Parse((string)parameter);
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public sealed class StringToDoubleConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return System.Convert.ToDouble(value);
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}

		#endregion
	}

	public class MultiBoolConverter : IMultiValueConverter
	{
		#region IValueConverter Members

		public virtual object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
		{
			return values.Length > 0 && values.All(value => (bool)value);
		}

		public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}

		#endregion
	}

	public class BooleanToScrollbarVisibilityConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return (bool)value ? ScrollBarVisibility.Auto : ScrollBarVisibility.Hidden;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}

		#endregion
	}

	public enum CompareOperator
	{
		Greater,
		Less,
		GreaterOrEqual,
		LessOrEqual,
		Equal
	}

	public class ValueCompareConverter : IValueConverter
	{
		public double Operand { get; set; }
		public CompareOperator Operator { get; set; }

		#region IMultiValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			//Convert value to double if possible. This will fit well on other numeric types.
			double a = System.Convert.ToDouble(value);
			double b = Operand;

			switch (Operator)
			{
				case CompareOperator.Greater:
					return a > b;
				case CompareOperator.Less:
					return a < b;
				case CompareOperator.GreaterOrEqual:
					return a >= b;
				case CompareOperator.LessOrEqual:
					return a <= b;
				case CompareOperator.Equal:
					return a == b;
				default:
					return false;
			}
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}

		#endregion
	}


	[ContentProperty("Converters")]
	public class CombiningConverter : IValueConverter
	{
		public List<IValueConverter> Converters { get; set; }

		public CombiningConverter()
		{
			Converters = new List<IValueConverter>();
		}

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return Converters.Aggregate(value, (r, a) => r = a.Convert(r, targetType, parameter, culture));
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return Converters.AsEnumerable().Reverse().Aggregate(value, (r, a) => r = a.Convert(r, targetType, parameter, culture));
		}
	}

	public class CollectionCountToBooleanConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (value == null)
				return false;
			if (((ICollection)value).Count == 0)
				return false;
			return true;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return null;
		}

		#endregion
	}


	public class StringEmptyToBooleanConverter : IValueConverter
	{
		#region IValueConverter Members

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			return String.IsNullOrEmpty((string)value);
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}

		#endregion
	}

	public class MethodConverter : IMultiValueConverter
	{
		public Func<object[], Type, object, CultureInfo, object> ConvertMethod { get; set; }
		public Func<object, Type[], object, CultureInfo, object[]> ConvertBackMethod { get; set; }

		public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
		{
			return ConvertMethod(values, targetType, parameter, culture);
		}

		public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
		{
			return ConvertBackMethod(value, targetTypes, parameter, culture);
		}
	}


	public class HostRequireApprovalConverter : IMultiValueConverter
	{
		#region IValueConverter Members

		public object Convert(object[] values, Type targetType, object parameter, CultureInfo culture)
		{
			//When using this converter always bind first value to a host's status,
			//to get this converter involved each time status changed.

			if (values == null || values.Any(a => a == null || a == DependencyProperty.UnsetValue))
			{
				return false;
			}

			VDS host = values[1] as VDS;
			if (host == null)
			{
				throw new NotSupportedException();
			}

			return VdcActionUtils.CanExecute(new[] { host }, typeof(VDS), VdcActionType.ApproveVds)
				//Special case where its installation failed but its oVirt node
				|| (host.status == VDSStatus.InstallFailed && host.vds_type == VDSType.oVirtNode);
		}

		public object[] ConvertBack(object value, Type[] targetTypes, object parameter, CultureInfo culture)
		{
			throw new NotSupportedException();
		}

		#endregion
	}


	public class StorageTypeGroupConverter : IValueConverter
	{
		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			var list = (IList<IStorageModel>)value;

			var items = list.GroupBy(a => a.Role)
				.Where(a => a.Cast<Model>().Count() > 0)
				.ToList();

			var result = new List<object>();
			foreach (var item in items)
			{
				result.Add(item.Key);
				item.Each(result.Add);
			}


			return result;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}
	}



	public class TemplateByTypeSelector : DataTemplateSelector
	{
		public string FindPattern { get; set; }
		public string DefaultTemplateKey { get; set; }

		public TemplateByTypeSelector()
		{
			FindPattern = "{0}Template";
			DefaultTemplateKey = "DefaultTemplate";
		}

		public override DataTemplate SelectTemplate(object item, DependencyObject container)
		{
			var element = (FrameworkElement)container;
			var resource = (DataTemplate)element.TryFindResource(String.Format(FindPattern, item.GetType().Name));

			return resource ?? (DataTemplate)element.TryFindResource(DefaultTemplateKey);
		}
	}
}
