﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Threading;
using org.ovirt.engine.ui.uicommon;

namespace UI.WPFClient
{
	public static class Extensions
	{
		public static T Resolve<T>(this TypeResolver resolver)
		{
			return (T)resolver.Resolve(typeof(T));
		}


		public static T FindAncestorOfType<T>(this DependencyObject child) where T : class
		{
			return FindAncestorOfTypeInternal<T>(child);
		}

		private static T FindAncestorOfTypeInternal<T>(DependencyObject child) where T : class
		{
			var parent = LogicalTreeHelper.GetParent(child);

			if (parent == null && child is FrameworkElement)
			{
				parent = (child as FrameworkElement).TemplatedParent;
			}

			if (parent == null || (parent != null && parent is T))
			{
				return parent as T;
			}
			else
			{
				return FindAncestorOfTypeInternal<T>(parent);
			}
		}


		public static IList<UIElement> DescendantsAndSelf(this UIElement root)
		{
			IList<UIElement> list = new List<UIElement>();
			DescendantsAndSelfInternal(list, root, null);

			return list;
		}

		public static IList<UIElement> DescendantsAndSelf(this UIElement root, Type exceptType)
		{
			IList<UIElement> list = new List<UIElement>();
			DescendantsAndSelfInternal(list, root, exceptType);

			return list;
		}

		private static void DescendantsAndSelfInternal(IList<UIElement> list, UIElement root, Type exceptType)
		{
			list.Add(root);

			foreach (object child in LogicalTreeHelper.GetChildren(root))
			{
				if (child is UIElement && !(child.GetType() == exceptType))
				{
					DescendantsAndSelfInternal(list, child as UIElement, exceptType);
				}
			}
		}

		public static T FindResource<T>(this FrameworkElement element, object resoureKey) where T : class
		{
			return element.TryFindResource(resoureKey) as T;
		}


		public static void AsyncEach<T>(this IEnumerable<T> source, DispatcherPriority priority, Action<T> action)
		{
			foreach (var item in source)
			{
				Dispatcher.CurrentDispatcher.BeginInvoke(priority, action, item);
			}
		}

		public static void Each<T>(this IEnumerable<T> source, Action<T> action)
		{
			foreach (var item in source)
			{
				action(item);
			}
		}
	}
}
