﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows;

namespace UI.WPFClient
{
	public delegate void IPTextBoxDelegate();
	class PartOfIPTextBox : TextBox
	{
		public event IPTextBoxDelegate OnBackSpace;
		public event IPTextBoxDelegate OnTab;
		public event IPTextBoxDelegate OnHome;
		public event IPTextBoxDelegate OnEnd;

		protected override void OnPreviewKeyDown(KeyEventArgs e)
		{
			string text = this.Text;

			if (e.Key == Key.Back && String.IsNullOrEmpty(text))
			{
				if (OnBackSpace != null)
					OnBackSpace();
			}
			switch (e.Key)
			{
				case Key.D0:
				case Key.D1:
				case Key.D2:
				case Key.D3:
				case Key.D4:
				case Key.D5:
				case Key.D6:
				case Key.D7:
				case Key.D8:
				case Key.D9:

				case Key.NumPad0:
				case Key.NumPad1:
				case Key.NumPad2:
				case Key.NumPad3:
				case Key.NumPad4:
				case Key.NumPad5:
				case Key.NumPad6:
				case Key.NumPad7:
				case Key.NumPad8:
				case Key.NumPad9:

					if (this.Text.Length >= 3 && this.SelectedText.Length == 0)
					{
						e.Handled = true;
						return;
					}
					if (Keyboard.Modifiers == ModifierKeys.Shift)
					{
						e.Handled = true;
						return;
					}
					int tempInt;
					if (int.TryParse(this.Text + GetNumber(e.Key).ToString(), out tempInt) && tempInt > 255 && this.SelectedText.Length == 0)
					{
						if (OnTab != null)
						{
							OnTab();
						}
						else
						{
							pressTab();
							e.Handled = true;
						}
						if (GetNumber(e.Key) == 0)
						{
							e.Handled = true;
						}
						return;
					}
					break;
				case Key.Back:
				case Key.Tab:
				case Key.Delete:
				case Key.Right:
				case Key.Left:
					break;
				case Key.OemPeriod:
				case Key.Decimal:
					if (OnTab != null)
					{
						OnTab();
					}
					e.Handled = true;
					break;
				case Key.Home:
					if (OnHome != null)
					{
						OnHome();
					}
					e.Handled = true;
					break;
				case Key.End:
					if (OnEnd != null)
					{
						OnEnd();
					}
					e.Handled = true;
					break;
				default:
					e.Handled = true;
					return;
			}
			base.OnPreviewKeyDown(e);

		}

		private void pressTab()
		{
			if (IsFocused == true)
			{
				KeyEventArgs eInsertBack = new KeyEventArgs(Keyboard.PrimaryDevice, Keyboard.PrimaryDevice.ActiveSource, 0, Key.Tab);
				if (eInsertBack == null)
					return;
				eInsertBack.RoutedEvent = UIElement.KeyDownEvent;
				InputManager.Current.ProcessInput(eInsertBack);
			}
		}
		protected override void OnTextChanged(TextChangedEventArgs e)
		{
			base.OnTextChanged(e);
			if (this.Text.Length == 3 || this.Text == "0")
			{
				if (OnTab != null)
				{
					OnTab();
				}
				else
				{
					pressTab();
				}
			}
		}

		protected override void OnGotFocus(System.Windows.RoutedEventArgs e)
		{
			this.SelectAll();
			base.OnGotFocus(e);
		}

		private int GetNumber(Key key)
		{
			switch (key)
			{
				case Key.D0:
				case Key.NumPad0:
					return 0;
				case Key.D1:
				case Key.NumPad1:
					return 1;
				case Key.D2:
				case Key.NumPad2:
					return 2;
				case Key.D3:
				case Key.NumPad3:
					return 3;
				case Key.D4:
				case Key.NumPad4:
					return 4;
				case Key.D5:
				case Key.NumPad5:
					return 5;
				case Key.D6:
				case Key.NumPad6:
					return 6;
				case Key.D7:
				case Key.NumPad7:
					return 7;
				case Key.D8:
				case Key.NumPad8:
					return 8;
				case Key.D9:
				case Key.NumPad9:
					return 9;
			}
			return 0;

		}

	}
}
