﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;

namespace UI.WPFClient
{
	public enum Location
	{
		Unknown,
		First,
		AfterFirst,
		Intermediate,
		BeforeLast,
		Last
	}


	public class ItemLocation : DependencyObject
	{
		public static Location GetLocation(DependencyObject obj)
		{
			return (Location)obj.GetValue(LocationProperty);
		}

		public static void SetLocation(DependencyObject obj, Location value)
		{
			obj.SetValue(LocationProperty, value);
		}

		public static readonly DependencyProperty LocationProperty =
			DependencyProperty.RegisterAttached("Location", typeof(Location), typeof(ItemLocation));
	}
}
