﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Windows.Input;
using System.Windows;
using System.Windows.Interactivity;
using System.Windows.Media.Animation;
using TriggerBase = System.Windows.TriggerBase;

namespace UI.WPFClient
{
	public class KeyTrigger : TriggerBase<FrameworkElement>
	{
		#region Properties

		public KeyGesture Gesture { get; set; }

		#endregion

		protected override void OnAttached()
		{
			base.OnAttached();

			AssociatedObject.KeyDown += AssociatedObject_KeyDown;
		}

		void AssociatedObject_KeyDown(object sender, KeyEventArgs e)
		{
			if (Gesture.Matches(sender, e))
			{
				InvokeActions(null);
				e.Handled = true;
			}
		}
	}



	public class ExecuteCommandAction : TriggerAction<FrameworkElement>
	{
		#region Properties

		public string TargetCommand { get; set; }

		#endregion

		protected override void Invoke(object parameter)
		{
			var dc = AssociatedObject.DataContext;
			if (dc != null)
			{
				var command = dc.GetType().GetProperty(TargetCommand).GetValue(dc, null) as ICommand;
				if (command != null && command.CanExecute(parameter))
				{
					command.Execute(parameter);
				}
			}
		}
	}


	public class EventTrigger : TriggerBase<FrameworkElement>
	{
		#region Property

		public string EventName { get; set; }

		#endregion

		private EventInfo ei;
		private EventHandler handler;

		protected override void OnAttached()
		{
			base.OnAttached();

			AssociatedObject.DataContextChanged += AssociatedObject_DataContextChanged;
		}

		void AssociatedObject_DataContextChanged(object sender, DependencyPropertyChangedEventArgs e)
		{
			if (e.OldValue != null)
			{
				RemoveHandler(e.OldValue);
			}

			if (e.NewValue != null)
			{
				Type t = e.NewValue.GetType();
				ei = t.GetEvent(EventName);
				handler = new EventHandler(OnEvent);
				ei.AddEventHandler(e.NewValue, handler);
			}
		}

		private void RemoveHandler(object dataContext)
		{
			Type t = dataContext.GetType();
			ei = t.GetEvent(EventName);
			ei.RemoveEventHandler(dataContext, handler);
		}

		protected override void OnDetaching()
		{
			AssociatedObject.DataContextChanged -= AssociatedObject_DataContextChanged;

			RemoveHandler(AssociatedObject.DataContext);

			base.OnDetaching();
		}

		private void OnEvent(object sender, EventArgs e)
		{
			InvokeActions(AssociatedObject.DataContext);
		}
	}


	public class BeginStoryboard : TriggerAction<FrameworkElement>
	{
		#region Properties

		public Storyboard Storyboard { get; set; }

		#endregion

		protected override void Invoke(object parameter)
		{
			Storyboard.Begin();
		}
	}
}
