using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace UI.WPFClient
{
	public class QGridViewColumn : GridViewColumn
	{
		public string SortPropertyName
		{
			get { return (string)GetValue(SortPropertyNameProperty); }
			set { SetValue(SortPropertyNameProperty, value); }
		}

		public static readonly DependencyProperty SortPropertyNameProperty =
			DependencyProperty.Register("SortPropertyName", typeof(string), typeof(QGridViewColumn), new UIPropertyMetadata(""));


		public bool IsDefaultSortColumn
		{
			get { return (bool)GetValue(IsDefaultSortColumnProperty); }
			set { SetValue(IsDefaultSortColumnProperty, value); }
		}

		public static readonly DependencyProperty IsDefaultSortColumnProperty =
			DependencyProperty.Register("IsDefaultSortColumn", typeof(bool), typeof(QGridViewColumn), new UIPropertyMetadata(false));


		public bool IsSorted
		{
			get { return (bool)GetValue(IsSortedProperty); }
			set { SetValue(IsSortedProperty, value); }
		}

		public static readonly DependencyProperty IsSortedProperty =
			DependencyProperty.Register("IsSorted", typeof(bool), typeof(QGridViewColumn), new UIPropertyMetadata(false));


		public ListSortDirection SortDirection
		{
			get { return (ListSortDirection)GetValue(SortDirectionProperty); }
			set { SetValue(SortDirectionProperty, value); }
		}

		public static readonly DependencyProperty SortDirectionProperty =
			DependencyProperty.Register("SortDirection", typeof(ListSortDirection), typeof(QGridViewColumn), new UIPropertyMetadata(ListSortDirection.Ascending));


		public string GroupPropertyName
		{
			get { return (string)GetValue(GroupPropertyNameProperty); }
			set { SetValue(GroupPropertyNameProperty, value); }
		}

		public static readonly DependencyProperty GroupPropertyNameProperty =
			DependencyProperty.Register("GroupPropertyName", typeof(string), typeof(QGridViewColumn), new UIPropertyMetadata(""));
	}
}
