﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Input;
using System.Windows.Interactivity;

namespace UI.WPFClient
{
	public class ResizableBehavior : Behavior<Thumb>
	{
		#region Properties

		public static bool GetIsResizing(DependencyObject obj)
		{
			return (bool)obj.GetValue(IsResizingProperty);
		}

		public static void SetIsResizing(DependencyObject obj, bool value)
		{
			obj.SetValue(IsResizingProperty, value);
		}
		public static readonly DependencyProperty IsResizingProperty =
			DependencyProperty.RegisterAttached("IsResizing", typeof(bool), typeof(ResizableBehavior));


		public FrameworkElement Target
		{
			get { return (FrameworkElement)GetValue(TargetProperty); }
			set { SetValue(TargetProperty, value); }
		}
		public static readonly DependencyProperty TargetProperty =
			DependencyProperty.Register("Target", typeof(FrameworkElement), typeof(ResizableBehavior));


		public bool HorizontalResize
		{
			get { return (bool)GetValue(HorizontalResizeProperty); }
			set { SetValue(HorizontalResizeProperty, value); }
		}
		public static readonly DependencyProperty HorizontalResizeProperty =
			DependencyProperty.Register("HorizontalResize", typeof(bool), typeof(ResizableBehavior));


		public bool VerticalResize
		{
			get { return (bool)GetValue(VerticalResizeProperty); }
			set { SetValue(VerticalResizeProperty, value); }
		}
		public static readonly DependencyProperty VerticalResizeProperty =
			DependencyProperty.Register("VerticalResize", typeof(bool), typeof(ResizableBehavior));

		#endregion

		private double width;
		private double height;

		protected override void OnAttached()
		{
			base.OnAttached();

			AssociatedObject.DragDelta += AssociatedObject_DragDelta;
		}

		protected override void OnDetaching()
		{
			base.OnDetaching();

			AssociatedObject.DragDelta -= AssociatedObject_DragDelta;
		}

		void AssociatedObject_DragDelta(object sender, DragDeltaEventArgs e)
		{
			if (HorizontalResize)
			{
				width = Target.ActualWidth;
				Target.Width = Math.Max(Target.MinWidth, width + e.HorizontalChange);
			}

			if (VerticalResize)
			{
				height = Target.ActualHeight;
				Target.Height = Math.Max(Target.MinHeight, height + e.VerticalChange);
			}
		}
	}
}
