using System;
using System.ComponentModel;
using System.Windows;
using System.Windows.Input;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using System.Windows.Controls;
using System.Collections;
using org.ovirt.engine.ui.uicommon.models.bookmarks;
using org.ovirt.engine.ui.uicommon.models;

namespace UI.WPFClient
{
	public partial class BookmarkListView
	{
		private WindowView view;

		public new BookmarkListModel Model
		{
			get { return base.Model as BookmarkListModel; }
			set { base.Model = value; }
		}


		public BookmarkListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.NewCommand)
				{
					view = TypeResolver.Instance.Resolve<BookmarkView>();
				}
				else if (Model.LastExecutedCommand == Model.EditCommand)
				{
					view = TypeResolver.Instance.Resolve<BookmarkView>();
				}
				else if (Model.LastExecutedCommand == Model.RemoveCommand)
				{
					view = TypeResolver.Instance.Resolve<ConfirmationView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}

		private void RemoveCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.RemoveCommand.Execute();
		}

		private void RemoveCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.RemoveCommand.IsExecutionAllowed;
		}

		private void EditCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.EditCommand.Execute();
		}

		private void EditCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.EditCommand.IsExecutionAllowed;
		}

		private void UIElement_OnMouseLeftButtonUp(object sender, MouseButtonEventArgs e)
		{
			ListBox listBox = (ListBox)sender;
			var model = Model as ListModel;
			if (model != null)
			{
				model.SelectedItem = null;
				model.SelectedItems = null;
				model.SelectedItem = listBox.SelectedItem;
				model.SelectedItems = new ArrayList(listBox.SelectedItems);
			}
		}
	}
}
