using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Practices.Unity;
using System.Collections;
using org.ovirt.engine.ui.uicommon;
using org.ovirt.engine.ui.uicommon.models;

namespace UI.WPFClient
{
	public partial class CommonView
	{
		private WindowView view;

		public new CommonModel Model
		{
			get { return (CommonModel)base.Model; }
			set { base.Model = value; }
		}


		public CommonView()
		{
			InitializeComponent();

			MouseDown += CommonView_MouseDown;
		}

		void CommonView_MouseDown(object sender, MouseButtonEventArgs e)
		{
			popup1.IsOpen = false;
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.AboutCommand)
				{
					view = TypeResolver.Instance.Resolve<AboutView>();
				}
				else if (Model.LastExecutedCommand == Model.ConfigureCommand)
				{
					view = TypeResolver.Instance.Resolve<ConfigureView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}

		private void AboutCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.AboutCommand.Execute();
		}

		private void GuideButton_Click(object sender, RoutedEventArgs e)
		{
			try
			{
				Process.Start(String.Format("{0}://{1}:{2}/rhev-docs/en-US/html/Administration_Guide/index.html", App.Scheme, App.Host, App.Port));
			}
			catch
			{
			}
		}


		private double finalBottomRowHeight;

		private void RaiseTabsButton_Checked(object sender, RoutedEventArgs e)
		{
			if (BottomRowHeight > 20)
			{
				return;
			}

			Storyboard storyboard = (Storyboard)TryFindResource("RaiseTabsStoryboard");
			DoubleAnimationUsingKeyFrames timeline = (DoubleAnimationUsingKeyFrames)storyboard.Children.First();
			SplineDoubleKeyFrame startFrame = (SplineDoubleKeyFrame)timeline.KeyFrames[0];
			SplineDoubleKeyFrame endFrame = (SplineDoubleKeyFrame)timeline.KeyFrames[1];

			startFrame.Value = 20;

			finalBottomRowHeight = 207;
			endFrame.Value = finalBottomRowHeight;
			storyboard.Begin();
			IsAnimationInProgress = true;
		}

		private void RaiseTabsButton_Unchecked(object sender, RoutedEventArgs e)
		{
			if (BottomRowHeight == 20)
			{
				return;
			}

			Storyboard storyboard = (Storyboard)TryFindResource("RaiseTabsStoryboard");
			DoubleAnimationUsingKeyFrames timeline = (DoubleAnimationUsingKeyFrames)storyboard.Children.First();
			SplineDoubleKeyFrame startFrame = (SplineDoubleKeyFrame)timeline.KeyFrames[0];
			SplineDoubleKeyFrame endFrame = (SplineDoubleKeyFrame)timeline.KeyFrames[1];

			startFrame.Value = BottomRowHeight;

			finalBottomRowHeight = 20;
			endFrame.Value = finalBottomRowHeight;
			storyboard.Begin();
			IsAnimationInProgress = true;
		}

		public bool IsAnimationInProgress
		{
			get { return (bool)GetValue(IsAnimationInProgressProperty); }
			set { SetValue(IsAnimationInProgressProperty, value); }
		}
		public static readonly DependencyProperty IsAnimationInProgressProperty =
			DependencyProperty.Register("IsAnimationInProgress", typeof(bool), typeof(CommonView), null);


		private void RaiseTabsStoryboard_Completed(object sender, EventArgs e)
		{
			BottomRowHeight = finalBottomRowHeight;

			IsAnimationInProgress = false;
		}

		public double BottomRowHeight
		{
			get { return (double)GetValue(BottomRowHeightProperty); }
			set { SetValue(BottomRowHeightProperty, value); }
		}
		public static readonly DependencyProperty BottomRowHeightProperty =
			DependencyProperty.Register("BottomRowHeight", typeof(double), typeof(CommonView), new UIPropertyMetadata(20d, BottomRowHeightChanged));


		private static void BottomRowHeightChanged(DependencyObject d, DependencyPropertyChangedEventArgs e)
		{
			var instance = (CommonView)d;
			instance.BottomRowHeightChanged();
		}

		private void BottomRowHeightChanged()
		{
			Storyboard storyboard = (Storyboard)TryFindResource("RaiseTabsStoryboard");

			ClockState clockState;
			try
			{
				clockState = storyboard.GetCurrentState();
			}
			catch (Exception)
			{
				clockState = ClockState.Stopped;
			}

			if (clockState != ClockState.Active)
			{
				RaiseTabsButton.Checked -= RaiseTabsButton_Checked;
				RaiseTabsButton.Unchecked -= RaiseTabsButton_Unchecked;

				RaiseTabsButton.IsChecked = BottomRowHeight > 20;

				RaiseTabsButton.Checked += RaiseTabsButton_Checked;
				RaiseTabsButton.Unchecked += RaiseTabsButton_Unchecked;
			}
		}

		private void Popup_Opened(object sender, EventArgs e)
		{
			popup1.HorizontalOffset = -textbox2.ActualWidth;
			popup1.Width = textbox1.ActualWidth + textbox2.ActualWidth;
		}

		private void MarketplaceButton_Click(object sender, RoutedEventArgs e)
		{
			Process.Start(HttpUtility.UrlPathEncode(Model.MarketplaceUrl));
		}
	}



	public class StyleToTagMapping
	{
		public object Tag { get; set; }
		public Style Style { get; set; }
	}

	public class StyleByTagSelector : StyleSelector
	{
		public string TagPropertyName { get; set; }
		public Style DefaultStyle { get; set; }
		public List<StyleToTagMapping> Mappings { get; set; }


		public StyleByTagSelector()
		{
			Mappings = new List<StyleToTagMapping>();
		}

		public override Style SelectStyle(object item, DependencyObject container)
		{
			Type t = item.GetType();
			var prop = t.GetProperty(TagPropertyName);
			if (prop != null)
			{
				object tag = prop.GetValue(item, null);

				//Find an apropriate style.
				var mapping = Mappings.SingleOrDefault(a => a.Tag.Equals(tag));
				if (mapping != null)
				{
					return mapping.Style;
				}
			}

			return DefaultStyle;
		}
	}
}
