using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicompat;
using Microsoft.Practices.Unity;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon;
using org.ovirt.engine.ui.uicommon.models.datacenters;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicommon.models.clusters;
using org.ovirt.engine.ui.uicommon.models.hosts;
using org.ovirt.engine.ui.uicommon.models.storage;
using org.ovirt.engine.ui.uicommon.models.configure;

namespace UI.WPFClient
{
	public partial class DataCenterListView
	{
		public new DataCenterListModel Model
		{
			get { return base.Model as DataCenterListModel; }
			set { base.Model = value; }
		}


		public DataCenterListView()
		{
			InitializeComponent();
		}

		private WindowView view1;
		private WindowView view2;

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName == "Window")
			{
				if (Model.Window != null)
				{
					if (Model.LastExecutedCommand == Model.NewCommand)
					{
						view1 = TypeResolver.Instance.Resolve<DataCenterView>();
					}
					else if (Model.LastExecutedCommand == Model.EditCommand)
					{
						view1 = TypeResolver.Instance.Resolve<DataCenterView>();
					}
					else if (Model.LastExecutedCommand == Model.RemoveCommand)
					{
						view1 = TypeResolver.Instance.Resolve<RemoveView>();
					}
					else if (Model.LastExecutedCommand == Model.ForceRemoveCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ForceRemoveDataCenterView>();
					}
					else if (Model.LastExecutedCommand == Model.RecoveryStorageCommand)
					{
						view1 = TypeResolver.Instance.Resolve<RecoveryStorageView>();
					}
					else if (Model.LastExecutedCommand == Model.GuideCommand)
					{
						view1 = TypeResolver.Instance.Resolve<DataCenterGuideView>();
					}
					else
					{
						throw new NotImplementedException();
					}

					view1.Model = Model.Window;
					WindowManager.AddWindow(view1);
				}
				else
				{
					WindowManager.RemoveWindow(view1);
					view1 = null;
				}
			}
			
			if (e.PropertyName == "ConfirmWindow")
			{
				if (Model.ConfirmWindow != null)
				{
					view2 = TypeResolver.Instance.Resolve<ConfirmationView>();
					WindowManager.AddWindow(view2);
					view2.Model = Model.ConfirmWindow;
				}
				else
				{
					WindowManager.RemoveWindow(view2);
					view2 = null;
				}
			}
		}

		private void RemoveCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.RemoveCommand.Execute();
		}

		private void RemoveCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.RemoveCommand.IsExecutionAllowed;
		}

		private void EditCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.EditCommand.Execute();
		}

		private void EditCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.EditCommand.IsExecutionAllowed;
		}

		private void NewCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.NewCommand.Execute();
		}

		private void GuideMeButton_Click(object sender, RoutedEventArgs e)
		{
			if (Model.Window != null && Model.Window.GetType() == typeof(DataCenterGuideModel))
			{
				return;
			}
			storage_pool dataCenter = (storage_pool)Model.SelectedItem;
			Model.GuideContext = dataCenter.Id;
			Model.GuideCommand.Execute();
		}
	}
}
