using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicompat;
using Microsoft.Practices.Unity;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon;
using System.ComponentModel;
using org.ovirt.engine.ui.uicommon.models.hosts;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicommon.models.configure;

namespace UI.WPFClient
{
	public partial class HostListView
	{
		private WindowView view1;
		private WindowView view2;

		public new HostListModel Model
		{
			get { return (HostListModel)base.Model; }
			set { base.Model = value; }
		}

		public HostListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName == "Window")
			{
				if (Model.Window != null)
				{
					if (Model.LastExecutedCommand == Model.NewCommand)
					{
						view1 = TypeResolver.Instance.Resolve<HostView>();
					}
					else if (Model.LastExecutedCommand == Model.EditCommand)
					{
						view1 = TypeResolver.Instance.Resolve<HostView>();
					}
					else if (Model.LastExecutedCommand == Model.RemoveCommand)
					{
						view1 = TypeResolver.Instance.Resolve<RemoveView>();
					}
					else if (Model.LastExecutedCommand == Model.ApproveCommand)
					{
						view1 = TypeResolver.Instance.Resolve<HostView>();
					}
					else if (Model.LastExecutedCommand == Model.AssignTagsCommand)
					{
						view1 = TypeResolver.Instance.Resolve<AssignTagsView>();
					}
					else if (Model.LastExecutedCommand == Model.ManualFenceCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ManualFenceView>();
					}
					else if (Model.LastExecutedCommand == Model.ConfigureLocalStorageCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ConfigureLocalStorageView>();
					}
					else
					{
						throw new NotImplementedException();
					}

					view1.Model = Model.Window;
					WindowManager.AddWindow(view1);
				}
				else
				{
					WindowManager.RemoveWindow(view1);
					view1 = null;
				}
			}

			if (e.PropertyName == "ConfirmWindow")
			{
				if (Model.ConfirmWindow != null)
				{
					view2 = TypeResolver.Instance.Resolve<ConfirmationView>();
					view2.Model = Model.ConfirmWindow;
					WindowManager.AddWindow(view2);
				}
				else
				{
					WindowManager.RemoveWindow(view2);
					view2 = null;
				}
			}
		}

		private void NewCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.NewCommand.Execute();
		}

		private void EditCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.EditCommand.Execute();
		}

		private void EditCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.EditCommand.IsExecutionAllowed;
		}

		private void RemoveCommand_Executed(object sender, ExecutedRoutedEventArgs e)
		{
			Model.RemoveCommand.Execute();
		}

		private void RemoveCommand_CanExecute(object sender, CanExecuteRoutedEventArgs e)
		{
			e.CanExecute = Model.RemoveCommand.IsExecutionAllowed;
		}

		private void ApproveButton_Click(object sender, RoutedEventArgs e)
		{
			FrameworkElement element = (FrameworkElement)sender;
			VDS host = (VDS)element.DataContext;

			//Select clicked grid row.
			Model.SelectedItem = host;

			Model.ApproveCommand.Execute();
		}
	}
}
