using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using org.ovirt.engine.ui.uicommon.models.hosts;

namespace UI.WPFClient
{
	public partial class HostVmListView
	{
		private WindowView view;

		public new HostVmListModel Model
		{
			get { return base.Model as HostVmListModel; }
			set { base.Model = value; }
		}

		public HostVmListView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName != "Window") return;

			if (Model.Window != null)
			{
				if (Model.LastExecutedCommand == Model.StopCommand)
				{
					view = TypeResolver.Instance.Resolve<ConfirmationView>();
				}
				else if (Model.LastExecutedCommand == Model.ShutdownCommand)
				{
					view = TypeResolver.Instance.Resolve<ConfirmationView>();
				}
				else if (Model.LastExecutedCommand == Model.MigrateCommand)
				{
					view = TypeResolver.Instance.Resolve<MigrateView>();
				}
				else
				{
					throw new NotImplementedException();
				}

				view.Model = Model.Window;
				WindowManager.AddWindow(view);
			}
			else
			{
				WindowManager.RemoveWindow(view);
				view = null;
			}
		}
	}
}
