using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicompat;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using System.ComponentModel;
using org.ovirt.engine.ui.uicommon.models.storage;
using org.ovirt.engine.ui.uicommon.models;

namespace UI.WPFClient
{
	public partial class VmBackupView
	{
		private WindowView view1;
		private WindowView view2;

		public new ManageBackupModel Model
		{
			get { return base.Model as ManageBackupModel; }
			set { base.Model = value; }
		}

		public VmBackupView()
		{
			InitializeComponent();
		}

		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName == "Window")
			{
				if (Model.Window != null)
				{
					if (Model.LastExecutedCommand == Model.RestoreCommand)
					{
						view1 = TypeResolver.Instance.Resolve<ImportVmView>();
					}
					else if (Model.LastExecutedCommand == Model.RemoveCommand)
					{
						view1 = TypeResolver.Instance.Resolve<RemoveView>();
					}
					else
					{
						throw new NotImplementedException();
					}

					view1.Model = Model.Window;
					WindowManager.AddWindow(view1);
				}
				else
				{
					WindowManager.RemoveWindow(view1);
					view1 = null;
				}
			}

			if (e.PropertyName == "ConfirmWindow")
			{
				if (Model.ConfirmWindow != null)
				{
					view2 = TypeResolver.Instance.Resolve<ConfirmationView>();
					view2.Model = Model.ConfirmWindow;
					WindowManager.AddWindow(view2);
				}
				else
				{
					WindowManager.RemoveWindow(view2);
					view2 = null;
				}
			}
		}
	}
}
