package org.ovirt.engine.core.common.queries;

import java.util.Arrays;

import org.ovirt.engine.core.common.businessentities.DiskImage;

import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamReader;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;

public class DiskImageList_CustomFieldSerializer {

    public static DiskImageList instantiate(
            SerializationStreamReader streamReader)
            throws SerializationException {

        // Handled in instantiate
        DiskImageList instance = new DiskImageList(Arrays.asList((DiskImage[]) streamReader.readObject()));
        instance.setCsharpworkaround(streamReader.readString());
        return instance;
    }

    public static void deserialize(SerializationStreamReader streamReader,
            DiskImageList instance) throws SerializationException {

    }

    public static void serialize(SerializationStreamWriter streamWriter,
            DiskImageList instance)
            throws SerializationException {

        streamWriter.writeObject(instance.getDiskImages());
        streamWriter.writeString(instance.getCsharpworkaround());
    }
}