using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicommon.models;
using org.ovirt.engine.ui.uicompat;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using VdcCommon.BusinessEntities;
using org.ovirt.engine.ui.uicommon.models.tags;

namespace UI.WPFClient
{
	public partial class SystemTreeView : IEventListener
	{
		public new SystemTreeModel Model
		{
			get { return base.Model as SystemTreeModel; }
			set { base.Model = value; }
		}


		public SystemTreeView()
		{
			InitializeComponent();
		}

		protected override void ModelChanging(Model newValue, Model oldValue)
		{
			base.ModelChanging(newValue, oldValue);

			var oldModel = oldValue as SystemTreeModel;
			if (oldModel != null)
			{
				oldModel.ResetRequestedEvent.removeListener(this);
			}

			var newModel = newValue as SystemTreeModel;
			if (newModel != null)
			{
				newModel.ResetRequestedEvent.addListener(this);
			}
		}

		public void eventRaised(Event ev, object sender, EventArgs args)
		{
			if (ev.Equals(SystemTreeModel.ResetRequestedEventDefinition))
			{
				Model_ResetRequested(sender, args);
			}
		}

		void Model_ResetRequested(object sender, EventArgs e)
		{
			TreeViewItem firstContainer = (TreeViewItem)treeview.ItemContainerGenerator.ContainerFromIndex(0);
			if (firstContainer != null)
			{
				firstContainer.IsSelected = true;
			}
		}

		private void TreeView_SelectedItemChanged(object sender, RoutedPropertyChangedEventArgs<object> e)
		{
			if (Model != null && (e.NewValue == null || e.NewValue is SystemTreeItemModel))
			{
				Model.SelectedItem = e.NewValue;
			}
		}
	}
}
