 PRINT 'Processing audit_log_sp.sql'

----------------------------------------------------------------
-- [dbo].[audit_log] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertAuditLog')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertAuditLog] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertAuditLog]
    @audit_log_id int OUT,  
 @log_time datetime,  
 @log_type int,  
    @log_type_name nvarchar(100)= NULL,  
 @severity int,  
 @message nvarchar(max),  
 @user_id uniqueidentifier = NULL,  
 @user_name nvarchar(255) = NULL,  
 @vds_id uniqueidentifier = NULL,  
 @vds_name nvarchar(255) = NULL,  
 @vm_id uniqueidentifier = NULL,  
 @vm_name nvarchar(255) = NULL,  
 @vm_template_id uniqueidentifier = NULL,  
    @vm_template_name nvarchar(40) = NULL,  
    @storage_pool_id UNIQUEIDENTIFIER = NULL,  
    @storage_pool_name NVARCHAR(40) = NULL,  
    @storage_domain_id UNIQUEIDENTIFIER = NULL,  
    @storage_domain_name NVARCHAR(250) = NULL,
    @vds_group_id uniqueidentifier = NULL,  
    @vds_group_name nvarchar(255) = NULL  
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
    declare @min_alret_severity int
	set @min_alret_severity = 10
	-- insert regular log messages (non alerts)
    if (@severity < @min_alret_severity)
	begin
		INSERT INTO [dbo].[audit_log] ([log_time], [log_type], [log_type_name], [severity],[message], [user_id], [user_name], [vds_id], [vds_name], [vm_id], [vm_name],[vm_template_id],[vm_template_name],[storage_pool_id],[storage_pool_name],[storage_domain_id],[storage_domain_name],[vds_group_id],[vds_group_name])
		VALUES (@log_time, @log_type, @log_type_name, @severity, @message, @user_id, @user_name, @vds_id, @vds_name, @vm_id, @vm_name,@vm_template_id,@vm_template_name,@storage_pool_id,@storage_pool_name,@storage_domain_id,@storage_domain_name,@vds_group_id,@vds_group_name)
		SET @audit_log_id = SCOPE_IDENTITY()
	end    
	else -- prevent inserting alert if it is alredy exists for the given VDS and log type
	begin
		if (not exists (select audit_log_id from audit_log where vds_name = @vds_name and log_type = @log_type))
		begin
			INSERT INTO [dbo].[audit_log] ([log_time], [log_type], [log_type_name], [severity],[message], [user_id], [user_name], [vds_id], [vds_name], [vm_id], [vm_name],[vm_template_id],[vm_template_name],[storage_pool_id],[storage_pool_name],[storage_domain_id],[storage_domain_name],[vds_group_id],[vds_group_name])
			VALUES (@log_time, @log_type, @log_type_name, @severity, @message, @user_id, @user_name, @vds_id, @vds_name, @vm_id, @vm_name,@vm_template_id,@vm_template_name,@storage_pool_id,@storage_pool_name,@storage_domain_id,@storage_domain_name,@vds_group_id,@vds_group_name)
			SET @audit_log_id = SCOPE_IDENTITY()
		end
		else 
		begin
			select @audit_log_id =  audit_log_id from audit_log where vds_name = @vds_name and log_type = @log_type
		end
	end
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateAuditLog')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateAuditLog] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateAuditLog]
    @audit_log_id int,  
 @log_time datetime,  
 @log_type int,  
 @severity int,  
 @message nvarchar(max),  
 @user_id uniqueidentifier = NULL,  
 @user_name nvarchar(255) = NULL,  
 @vds_id uniqueidentifier = NULL,  
 @vds_name nvarchar(255) = NULL,  
 @vm_id uniqueidentifier = NULL,  
 @vm_name nvarchar(255) = NULL,   
 @vm_template_id uniqueidentifier = NULL,  
    @vm_template_name nvarchar(40) = NULL,  
    @storage_pool_id UNIQUEIDENTIFIER = NULL,  
    @storage_pool_name NVARCHAR(40) = NULL,  
    @storage_domain_id UNIQUEIDENTIFIER = NULL,  
    @storage_domain_name NVARCHAR(250) = NULL,  
    @vds_group_id uniqueidentifier = NULL,  
    @vds_group_name nvarchar(255) = NULL  
AS
BEGIN

	--The [dbo].[audit_log] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[audit_log] 
	SET [log_time] = @log_time, [log_type] = @log_type, [severity] = @severity, [message] = @message, [user_id] = @user_id, [user_name] = @user_name, [vds_id] = @vds_id, [vds_name] = @vds_name, [vm_id] = @vm_id, [vm_name] = @vm_name,[vm_template_id] = @vm_template_id, [vm_template_name] = @vm_template_name,
	[storage_pool_id] = @storage_pool_id, [storage_pool_name] = @storage_pool_name, [storage_domain_id] = @storage_domain_id, [storage_domain_name] = @storage_domain_name, [vds_group_id] = @vds_group_id, [vds_group_name] = @vds_group_name
	WHERE [audit_log_id]=@audit_log_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteAuditLog')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteAuditLog] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteAuditLog]
	 @audit_log_id int
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		declare @val int
		-- Get (and keep) a shared lock with "right to upgrade to exclusive"
		-- in order to force locking parent before children 
		SELECT @val = [audit_log_id]
		FROM [dbo].[audit_log] WITH (UPDLOCK)
		WHERE [audit_log_id]=@audit_log_id

		DELETE FROM [dbo].[audit_log]
		WHERE [audit_log_id]=@audit_log_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromAuditLog')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromAuditLog] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromAuditLog]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[audit_log].[audit_log_id] AS 'audit_log_id',
		[audit_log].[log_time] AS 'log_time',
		[audit_log].[log_type] AS 'log_type',
		[audit_log].[severity] AS 'severity',
		[audit_log].[message] AS 'message',
		[audit_log].[user_id] AS 'user_id',
		[audit_log].[user_name] AS 'user_name',
		[audit_log].[vds_id] AS 'vds_id',
		[audit_log].[vds_name] AS 'vds_name',
		[audit_log].[vm_id] AS 'vm_id',
		[audit_log].[vm_name] AS 'vm_name',
		[audit_log].[vm_template_id] AS 'vm_template_id',
		[audit_log].[vm_template_name] AS 'vm_template_name',
		[audit_log].[storage_pool_id] AS 'storage_pool_id',
		[audit_log].[storage_pool_name] AS 'storage_pool_name',
		[audit_log].[storage_domain_id] AS 'storage_domain_id',
		[audit_log].[storage_domain_name] AS 'storage_domain_name',
		[audit_log].[vds_group_id] AS 'vds_group_id',
		[audit_log].[vds_group_name] AS 'vds_group_name'
		FROM [dbo].[audit_log] [audit_log]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAuditLogByAuditLogId')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAuditLogByAuditLogId] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAuditLogByAuditLogId] 
	@audit_log_id int
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[audit_log].[audit_log_id] AS 'audit_log_id',
		[audit_log].[log_time] AS 'log_time',
		[audit_log].[log_type] AS 'log_type',
		[audit_log].[severity] AS 'severity',
		[audit_log].[message] AS 'message',
		[audit_log].[user_id] AS 'user_id',
		[audit_log].[user_name] AS 'user_name',
		[audit_log].[vds_id] AS 'vds_id',
		[audit_log].[vds_name] AS 'vds_name',
		[audit_log].[vm_id] AS 'vm_id',
		[audit_log].[vm_name] AS 'vm_name',
		[audit_log].[vm_template_id] AS 'vm_template_id',
		[audit_log].[vm_template_name] AS 'vm_template_name',
		[audit_log].[storage_pool_id] AS 'storage_pool_id',
		[audit_log].[storage_pool_name] AS 'storage_pool_name',
		[audit_log].[storage_domain_id] AS 'storage_domain_id',
		[audit_log].[storage_domain_name] AS 'storage_domain_name',
		[audit_log].[vds_group_id] AS 'vds_group_id',
		[audit_log].[vds_group_name] AS 'vds_group_name'
		FROM [dbo].[audit_log] [audit_log]
		WHERE [audit_log_id]=@audit_log_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAuditLogLaterThenDate')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAuditLogLaterThenDate] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAuditLogLaterThenDate]
	@date datetime 
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[audit_log].[audit_log_id] AS 'audit_log_id',
		[audit_log].[log_time] AS 'log_time',
		[audit_log].[log_type] AS 'log_type',
		[audit_log].[severity] AS 'severity',
		[audit_log].[message] AS 'message',
		[audit_log].[user_id] AS 'user_id',
		[audit_log].[user_name] AS 'user_name',
		[audit_log].[vds_id] AS 'vds_id',
		[audit_log].[vds_name] AS 'vds_name',
		[audit_log].[vm_id] AS 'vm_id',
		[audit_log].[vm_name] AS 'vm_name',
		[audit_log].[vm_template_id] AS 'vm_template_id',
		[audit_log].[vm_template_name] AS 'vm_template_name',
		[audit_log].[storage_pool_id] AS 'storage_pool_id',
		[audit_log].[storage_pool_name] AS 'storage_pool_name',
		[audit_log].[storage_domain_id] AS 'storage_domain_id',
		[audit_log].[storage_domain_name] AS 'storage_domain_name',
		[audit_log].[vds_group_id] AS 'vds_group_id',
		[audit_log].[vds_group_name] AS 'vds_group_name'
		FROM [dbo].[audit_log] [audit_log]
		WHERE [log_time]>=@date
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteAuditLogOlderThenDate')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteAuditLogOlderThenDate] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteAuditLogOlderThenDate]
	@date datetime 
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
        declare @id int
        -- get first the id from which to remove in order to use index
        select top 1 @id = [audit_log_id]
		FROM [dbo].[audit_log]
		WHERE [log_time]<@date
        order by [audit_log_id] desc
        -- check if there are candidates to remove
		if (@@rowcount > 0)
        begin
			DELETE FROM [dbo].[audit_log]
			WHERE [audit_log_id]<= @id and [processed] = 1 and
			audit_log_id not in 
			(select audit_log_id from event_notification_hist)
		end
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteAuditAlertLogByVdsIDAndType')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteAuditAlertLogByVdsIDAndType] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteAuditAlertLogByVdsIDAndType]
	@vds_id uniqueidentifier,
    @log_type int
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		delete from audit_log where vds_id = @vds_id and log_type = @log_type
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteAuditLogAlertsByVdsID')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].DeleteAuditLogAlertsByVdsID AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteAuditLogAlertsByVdsID]
	@vds_id uniqueidentifier,
    @delete_config_alerts bit = 1
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		declare @min_alret_severity int
		declare @no_config_alret_type int
		set @min_alret_severity = 10
		set @no_config_alret_type = 9000
	    if (@delete_config_alerts=1)
		begin
			delete from audit_log where vds_id = @vds_id and severity >= @min_alret_severity
		end
		else 
		begin
			delete from audit_log where vds_id = @vds_id and severity >= @min_alret_severity and log_type > @no_config_alret_type
		end
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END
GO
