PRINT 'Processing vdc_option_sp.sql'

----------------------------------------------------------------
-- [dbo].[vdc_options] Table
--
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'InsertVdcOption')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[InsertVdcOption] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[InsertVdcOption]
    @option_name nvarchar(50),
	@option_value nvarchar(50),
	@version nvarchar(40),
	@option_id int OUT
AS
BEGIN
	SET NOCOUNT ON
	
	BEGIN TRY
    INSERT INTO [dbo].[vdc_options] ([option_name], [option_value], [version])
	VALUES (@option_name, @option_value, @version)
    SET @option_id = SCOPE_IDENTITY()
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END    

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'UpdateVdcOption')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[UpdateVdcOption] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[UpdateVdcOption]
    @option_name nvarchar(50),
	@option_value nvarchar(50),
	@option_id int,
	@version nvarchar(40)
AS
BEGIN

	--The [dbo].[vdc_options] table doesn't have a timestamp column. Optimistic concurrency logic cannot be generated
	SET NOCOUNT ON

	BEGIN TRY
	UPDATE [dbo].[vdc_options] 
	SET [option_name] = @option_name, [option_value] = @option_value, [version] = @version
	WHERE [option_id]=@option_id

	IF @@ROWCOUNT = 0
	BEGIN
		RAISERROR('Update statement affected 0 rows.', 16, 2)
	END
    END TRY

    BEGIN CATCH
		EXEC RethrowError;
	END CATCH	

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'DeleteVdcOption')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[DeleteVdcOption] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[DeleteVdcOption]
	 @option_id int
AS
BEGIN
	SET NOCOUNT ON
	BEGIN TRY
		DELETE FROM [dbo].[vdc_options]
		WHERE [option_id]=@option_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH
    
    SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetAllFromVdcOption')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetAllFromVdcOption] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetAllFromVdcOption]    
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vdc_options].[option_name] AS 'option_name',
		[vdc_options].[option_value] AS 'option_value',
		[vdc_options].[option_id] AS 'option_id',
		[vdc_options].[version] AS 'version'
		FROM [dbo].[vdc_options] [vdc_options]
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdcOptionById')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdcOptionById] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdcOptionById] 
	@option_id int
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vdc_options].[option_name] AS 'option_name',
		[vdc_options].[option_value] AS 'option_value',
		[vdc_options].[option_id] AS 'option_id',
		[vdc_options].[version] AS 'version'
		FROM [dbo].[vdc_options] [vdc_options]
		WHERE [option_id]=@option_id
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'P' AND NAME = 'GetVdcOptionByName')
BEGIN
	EXEC('CREATE PROCEDURE [dbo].[GetVdcOptionByName] AS RETURN')
END

GO

ALTER PROCEDURE [dbo].[GetVdcOptionByName] 
	@option_name nvarchar(50),
	@version nvarchar(40)
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET NOCOUNT ON
	BEGIN TRY
		SELECT
		[vdc_options].[option_name] AS 'option_name',
		[vdc_options].[option_value] AS 'option_value',
		[vdc_options].[option_id] AS 'option_id',
		[vdc_options].[version] AS 'version'
		FROM [dbo].[vdc_options] [vdc_options]
		WHERE [option_name]=@option_name and [version] = @version
	END TRY
	BEGIN CATCH
		EXEC RethrowError;
	END CATCH

	SET NOCOUNT OFF
END

GO