﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace org.ovirt.engine.ui.uicommon
{
	public class TypeResolver
	{
		public static TypeResolver Instance { get; private set; }

		private readonly ITypeResolver implementation;


		private TypeResolver(ITypeResolver implementation)
		{
			this.implementation = implementation;
		}

		public static void Initialize(ITypeResolver implementation)
		{
			Instance = new TypeResolver(implementation);
		}

		public virtual object Resolve(Type type)
		{
			return implementation.Resolve(type);
		}
	}
}
