using System;
using System.Collections.Generic;
using System.Text;
using System.Windows;
using System.Windows.Input;
using VdcCommon.BusinessEntities;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.templates
{
	public class TemplateGeneralModel : EntityModel
	{

		#region Properties

		public new VmTemplate Entity
		{
			get
			{
				if(base.Entity == null)
				{
					return null;
				}
				if (base.Entity is VmTemplate)
				{
					return (VmTemplate)base.Entity;
				}
				else
				{
					KeyValuePair<VmTemplate, List<DiskImage>> pair = (KeyValuePair<VmTemplate, List<DiskImage>>)base.Entity;
					return pair.Key;
				}
			}
			set { base.Entity = value; }
		}


	
		private string cpuInfo;
		public string CpuInfo
		{
			get { return cpuInfo; }
			set
			{
				if (cpuInfo != value)
				{
					cpuInfo = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CpuInfo"));
				}
			}
		}

		private bool hasTimeZone;
		public bool HasTimeZone
		{
			get { return hasTimeZone; }
			set
			{
				if (hasTimeZone != value)
				{
					hasTimeZone = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasTimeZone"));
				}
			}
		}

		private bool hasDomain;
		public bool HasDomain
		{
			get { return hasDomain; }
			set
			{
				if (hasDomain != value)
				{
					hasDomain = value;
					OnPropertyChanged(new PropertyChangedEventArgs("HasDomain"));
				}
			}
		}
		#endregion


		public TemplateGeneralModel()
		{
			Title = "General";
		}

		protected override void OnEntityChanged()
		{
			base.OnEntityChanged();

			if (base.Entity != null)
			{
				UpdateProperties();
			}
		}

		protected override void EntityPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.EntityPropertyChanged(sender, e);

			if (e.PropertyName == "num_of_cpus")
			{
				UpdateProperties();
			}
		}

		private void UpdateProperties()
		{
			VmTemplate template = Entity;

			CpuInfo = string.Format("{0} ({1} Socket(s), {2} Core(s) per Socket)", template.num_of_cpus, template.num_of_sockets, template.cpu_per_socket);

			HasTimeZone = DataProvider.IsWindowsOsType(template.os);
			HasDomain = DataProvider.IsWindowsOsType(template.os);
		}
	}
}
