﻿using System;
using System.Xml.Serialization;

namespace VdcCommon.BusinessEntities
{
    public partial class VdcActionParametersBase
    {
        public VdcActionParametersBase()
        {
            TaskStartTime = DateTime.Now.Ticks;
            ParentCommand = VdcActionType.Unknown;
        }
    }

    public partial class VdcReturnValueBase
    {
        [XmlIgnore]
        public VdcFault Fault
        {
            get
            {
                if (_fault == null)
                {
                    _fault = new VdcFault();
                    _fault.Error = VdcBllErrors.ENGINE;
                    _fault.Message = VdcBllErrors.ENGINE.ToString();
                }
                return _fault;
            }
            set { _fault = value; }
        }


        [XmlIgnoreAttribute]
        public bool HasAsyncTasks
        {
            get
            {
                return (TaskIdList != null && TaskIdList.Length > 0);
            }
        }
    }
}
