using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;

namespace org.ovirt.engine.ui.uicompat
{
	/// <summary>
	/// Implements notification about property change, need by WPF GUI.
	/// This class should not be converted to Java.
	/// </summary>
	public abstract class PropertyChangeNotifier : INotifyPropertyChanged
	{
		public event PropertyChangedEventHandler PropertyChanged = delegate { };


		protected virtual void OnPropertyChanged(PropertyChangedEventArgs e)
		{
			PropertyChanged(this, e);
		}
	}
}
