using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Windows;
using org.ovirt.engine.ui.uicommon.models.common;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.VdcQueries;
using VdcFrontend;
using VdcCommon.Interfaces;
using VdcCommon.BusinessEntities;
using System.Collections.ObjectModel;
using System.Collections;

namespace org.ovirt.engine.ui.uicommon.models.configure.roles_ui
{
	public class RoleModel : Model
	{
		#region Commands

		public UICommand ExpandAllCommand { get; private set; }
		public UICommand CollapseAllCommand { get; private set; }

		#endregion Commands

		#region Properties

		public bool IsNew { get; set; }

		public EntityModel IsAdminRole { get; set; }

		public EntityModel Name { get; private set; }
		public EntityModel Description { get; private set; }

		private List<SelectionTreeNodeModel> permissionGroupModels;
		public List<SelectionTreeNodeModel> PermissionGroupModels
		{
			get { return permissionGroupModels; }
			set
			{
				if (permissionGroupModels != value)
				{
					permissionGroupModels = value;
					OnPropertyChanged(new PropertyChangedEventArgs("PermissionGroupModels"));
				}
			}
		}

		#endregion

		public RoleModel()
		{
			ExpandAllCommand = new UICommand("ExpandAll", this);
			CollapseAllCommand = new UICommand("CollapseAll", this);

			Name = new EntityModel();
			Description = new EntityModel();
			IsAdminRole = new EntityModel();
		}

		public void ExpandAll()
		{
			//PermissionGroupModels.Each(a => a.IsExpanded = true );
			foreach (SelectionTreeNodeModel stm in PermissionGroupModels)
			{
				stm.IsExpanded = true;
				foreach (SelectionTreeNodeModel stmChild in stm.Children)
				{
					stmChild.IsExpanded = true;
				}
			}
		}

		public void CollapseAll()
		{
			//PermissionGroupModels.Each(a => a.IsExpanded = false);
			foreach (SelectionTreeNodeModel stm in PermissionGroupModels)
			{
				stm.IsExpanded = false;
				foreach (SelectionTreeNodeModel stmChild in stm.Children)
				{
					stmChild.IsExpanded = false;
				}
			}
		}

		internal bool Validate()
		{
			Name.ValidateEntity(
				new IValidation[]
				{
					new NotEmptyValidation(),
					new RegexValidation 
					{
						Expression = @"^\w.{0,125}$",
						Message = "Name must be up to 126 characters and start with any word character."
					},
					new RegexValidation()
						{
							Expression= "^[A-Za-z0-9_-]+$",
							Message = "Name can contain only 'A-Z', 'a-z', '0-9', '_' or '-' characters."
						}
					
				});

			return Name.IsValid;
		}

		public override void ExecuteCommand(UICommand command)
		{
			base.ExecuteCommand(command);

			if (command == ExpandAllCommand)
			{
				ExpandAll();
			}
			else if (command == CollapseAllCommand)
			{
				CollapseAll();
			}
		}
	}
}
