using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using org.ovirt.engine.ui.uicommon.models.tags;
using org.ovirt.engine.ui.uicommon.validation;

namespace org.ovirt.engine.ui.uicommon.models.users
{
	public class UserPermissionModel : Model
	{
		#region Properties

		public Guid Id { get; set; }

		public ListModel Role { get; set; }

		private IList<TagModel> tags;
		public IList<TagModel> Tags
		{
			get { return tags; }
			set
			{
				if (tags != value)
				{
					tags = value;
					OnPropertyChanged(new PropertyChangedEventArgs("Tags"));
				}
			}
		}

		#endregion

		public UserPermissionModel()
		{
			Role = new ListModel();
		}

		internal bool Validate()
		{
			Role.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			return Role.IsValid;
		}
	}
}
