using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using org.ovirt.engine.ui.uicompat;
using Microsoft.Practices.Unity;
using org.ovirt.engine.ui.uicommon;
using System.ComponentModel;
using org.ovirt.engine.ui.uicommon.models.hosts;
using org.ovirt.engine.ui.uicommon.models;

namespace UI.WPFClient
{
	public partial class HostInterfaceListView
	{
		private WindowView view1;
		private WindowView view2;

		public new HostInterfaceListModel Model
		{
			get { return base.Model as HostInterfaceListModel; }
			set { base.Model = value; }
		}

		public HostInterfaceListView()
		{
			InitializeComponent();
		}

		// In case DetachConfirmationNeeded == true in the HostInterfaceListModel,
		// we need to display a confirmation dialog to the user.
		protected override void ModelPropertyChanged(object sender, PropertyChangedEventArgs e)
		{
			base.ModelPropertyChanged(sender, e);

			if (e.PropertyName == "Window")
			{
				if (Model.Window != null)
				{
					if (Model.LastExecutedCommand == Model.EditCommand)
					{
						view1 = TypeResolver.Instance.Resolve<HostInterfaceView>();
					}
					else if (Model.LastExecutedCommand == Model.EditManagementNetworkCommand)
					{
						view1 = TypeResolver.Instance.Resolve<HostManagementNetworkView>();
					}
					else if (Model.LastExecutedCommand == Model.BondCommand)
					{
						view1 = TypeResolver.Instance.Resolve<HostBondView>();
					}
					else if (Model.LastExecutedCommand == Model.DetachCommand)
					{
						view1 = TypeResolver.Instance.Resolve<DetachNetworkView>();
					}
					else
					{
						throw new NotImplementedException();
					}

					view1.Model = Model.Window;
					WindowManager.AddWindow(view1);
				}
				else
				{
					WindowManager.RemoveWindow(view1);
					view1 = null;
				}
			}

			if (e.PropertyName == "ConfirmWindow")
			{
				if (Model.LastExecutedCommand.Name == "OnEditManagementNetworkConfirmation"
					|| Model.LastExecutedCommand.Name == "OnEditManagementNetworkConfirmation_Bond")
				{
					view2 = TypeResolver.Instance.Resolve<HostManagementConfirmationView>();
					view2.Model = Model.ConfirmWindow;
					WindowManager.AddWindow(view2);
				}
				else if (Model.ConfirmWindow != null)
				{
					view2 = TypeResolver.Instance.Resolve<ConfirmationView>();
					view2.Model = Model.ConfirmWindow;
					WindowManager.AddWindow(view2);
				}
				else
				{
					WindowManager.RemoveWindow(view2);
					view2 = null;
				}
			}
		}
	}
}
