using System;
using System.Collections.Generic;
using System.Text;
using org.ovirt.engine.ui.uicommon.validation;
using VdcCommon.BusinessEntities;
using System.ComponentModel;

namespace org.ovirt.engine.ui.uicommon.models.hosts
{
	public class HostManagementNetworkModel : EntityModel
	{
		#region Properties

		public new network Entity
		{
			get { return (network)base.Entity; }
			set { base.Entity = value; }
		}

		public ListModel Interface { get; private set; }
		public EntityModel Address { get; private set; }
		public EntityModel Subnet { get; private set; }
		public EntityModel Gateway { get; private set; }
		public EntityModel CheckConnectivity { get; private set; }
		public ListModel BondingOptions { get; private set; }

		private NetworkBootProtocol bootProtocol;
		public NetworkBootProtocol BootProtocol
		{
			get
			{
				return bootProtocol;
			}

			set
			{
				if (bootProtocol != value)
				{
					bootProtocol = value;
					BootProtocolChanged();
					OnPropertyChanged(new PropertyChangedEventArgs("BootProtocol"));
				}
			}
		}

		private bool noneBootProtocolAvailable = true;
		public bool NoneBootProtocolAvailable
		{
			get
			{
				return noneBootProtocolAvailable;
			}

			set
			{
				if (noneBootProtocolAvailable != value)
				{
					noneBootProtocolAvailable = value;
					OnPropertyChanged(new PropertyChangedEventArgs("NoneBootProtocolAvailable"));
				}
			}
		}

		public bool IsStaticAddress
		{
			get
			{
				return BootProtocol == NetworkBootProtocol.StaticIp;
			}
		}

		private bool commitChanges;
		public bool CommitChanges
		{
			get { return commitChanges; }
			set
			{
				if (commitChanges != value)
				{
					commitChanges = value;
					OnPropertyChanged(new PropertyChangedEventArgs("CommitChanges"));
				}
			}
		}

		private bool bondingOptionsOverrideNotification { get; set; }
		public bool BondingOptionsOverrideNotification
		{
			get
			{
				return bondingOptionsOverrideNotification;
			}
			set
			{
				bondingOptionsOverrideNotification = value;
				OnPropertyChanged(new PropertyChangedEventArgs("BondingOptionsOverrideNotification"));
			}
		}

		#endregion

		public HostManagementNetworkModel()
		{
			Interface = new ListModel();
			Address = new EntityModel();
			Subnet = new EntityModel();
			Gateway = new EntityModel();

			CheckConnectivity = new EntityModel();
			CheckConnectivity.Entity = false;
			BondingOptions = new ListModel();
			UpdateFieldsByEntity();
		}

		private void UpdateFieldsByEntity()
		{
			UpdateCanSpecify();

			// ** TODO: When BootProtocol will be added to 'network', and when
			// ** BootProtocol, Address, Subnet, and Gateway will be added to 
			// ** the Network Add/Edit dialog, the next lines will be uncommented.
			// ** DO NOT DELETE NEXT COMMENTED LINES!
			//var network = (network)Network;
			//BootProtocol = network == null ? null : network.bootProtocol;
			//Address.Value = network == null ? null : network.addr;
			//Subnet.Value = network == null ? null : network.subnet;
			//Gateway.Value = network == null ? null : network.gateway;
		}

		private void BootProtocolChanged()
		{
			UpdateCanSpecify();

			Address.IsValid = true;
			Subnet.IsValid = true;
			Gateway.IsValid = true;
		}

		private void UpdateCanSpecify()
		{
			Address.IsChangable = IsStaticAddress;
			Subnet.IsChangable = IsStaticAddress;
			Gateway.IsChangable = IsStaticAddress;
		}

		internal virtual bool Validate()
		{
			Interface.ValidateSelectedItem(new IValidation[] { new NotEmptyValidation() });

			Address.IsValid = true;
			Subnet.IsValid = true;

			if (IsStaticAddress)
			{
				Address.ValidateEntity(new IValidation[] { new NotEmptyValidation(), new IpAddressValidation() });
				Subnet.ValidateEntity(new IValidation[] { new NotEmptyValidation(), new IpAddressValidation() });
			}

			return Interface.IsValid
				   && Address.IsValid
				   && Subnet.IsValid;
		}
	}
}
