/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSType;
import com.microsoft.sqlserver.jdbc.UDTTDSHeader;
import com.microsoft.sqlserver.jdbc.XMLTDSHeader;
import java.text.MessageFormat;

final class TypeInfo {
    private int maxLength;
    private int valueLengthSize;
    private int precision;
    private int scale;
    private short flags;
    private SSType ssType;
    private UDTTDSHeader udtTDSHeader;
    private XMLTDSHeader xmlTDSHeader;
    private SQLCollation collation;
    private String charset;
    static int UPDATABLE_READ_ONLY = 0;
    static int UPDATABLE_READ_WRITE = 1;
    static int UPDATABLE_UNKNOWN = 2;

    TypeInfo() {
    }

    SSType getSSType() {
        return this.ssType;
    }

    int getMaxLength() {
        return this.maxLength;
    }

    int getValueLengthSize() {
        return this.valueLengthSize;
    }

    int getPrecision() {
        return this.precision;
    }

    int getScale() {
        return this.scale;
    }

    SQLCollation getSQLCollation() {
        return this.collation;
    }

    String getCharset() {
        return this.charset;
    }

    boolean isNullable() {
        return 1 == (this.flags & 1);
    }

    boolean isCaseSensitive() {
        return 2 == (this.flags & 2);
    }

    int getUpdatability() {
        return this.flags >> 2 & 3;
    }

    boolean isIdentity() {
        return 16 == (this.flags & 0x10);
    }

    boolean isPLPType() {
        switch (this.ssType) {
            case VARBINARYMAX: 
            case VARCHARMAX: 
            case NVARCHARMAX: 
            case UDT: 
            case XML: {
                return true;
            }
        }
        return false;
    }

    boolean supportsFastAsciiConversion() {
        switch (this.ssType) {
            case VARCHARMAX: 
            case CHAR: 
            case VARCHAR: 
            case TEXT: {
                return this.collation.hasAsciiCompatibleSBCS();
            }
        }
        return false;
    }

    String getSSTypeName() {
        return null != this.udtTDSHeader ? this.udtTDSHeader.getTypeName() : this.ssType.toString();
    }

    void setFromTDS(TDSReader tDSReader) throws SQLServerException {
        this.maxLength = 0;
        this.valueLengthSize = 0;
        this.precision = 0;
        this.scale = 0;
        this.udtTDSHeader = null;
        this.xmlTDSHeader = null;
        int n = tDSReader.getConnection().isYukonOrLater() ? tDSReader.readInt() : (int)tDSReader.readShort();
        this.flags = tDSReader.readShort();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = tDSReader.readUnsignedByte();
        TDSType tDSType = TDSType.valueOf(n2);
        block0 : switch (tDSType) {
            case INT8: 
            case INT4: 
            case INT2: 
            case INT1: 
            case INTN: {
                switch (tDSType) {
                    case INT8: {
                        this.maxLength = 8;
                        break;
                    }
                    case INT4: {
                        this.maxLength = 4;
                        break;
                    }
                    case INT2: {
                        this.maxLength = 2;
                        break;
                    }
                    case INT1: {
                        this.maxLength = 1;
                        break;
                    }
                    case INTN: {
                        this.valueLengthSize = 1;
                        this.maxLength = tDSReader.readUnsignedByte();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                switch (this.maxLength) {
                    case 8: {
                        this.ssType = SSType.BIGINT;
                        this.precision = 19;
                        break block0;
                    }
                    case 4: {
                        this.ssType = SSType.INTEGER;
                        this.precision = 10;
                        break block0;
                    }
                    case 2: {
                        this.ssType = SSType.SMALLINT;
                        this.precision = 5;
                        break block0;
                    }
                    case 1: {
                        this.ssType = SSType.TINYINT;
                        this.precision = 3;
                        break block0;
                    }
                }
                tDSReader.throwInvalidTDS();
                break;
            }
            case MONEY8: 
            case MONEY4: 
            case MONEYN: {
                switch (tDSType) {
                    case MONEY8: {
                        this.maxLength = 8;
                        break;
                    }
                    case MONEY4: {
                        this.maxLength = 4;
                        break;
                    }
                    case MONEYN: {
                        this.valueLengthSize = 1;
                        this.maxLength = tDSReader.readUnsignedByte();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                switch (this.maxLength) {
                    case 8: {
                        this.ssType = SSType.MONEY;
                        this.precision = 19;
                        this.scale = 4;
                        break block0;
                    }
                    case 4: {
                        this.ssType = SSType.SMALLMONEY;
                        this.precision = 10;
                        this.scale = 4;
                        break block0;
                    }
                }
                tDSReader.throwInvalidTDS();
                break;
            }
            case DATETIME8: 
            case DATETIME4: 
            case DATETIMEN: {
                switch (tDSType) {
                    case DATETIME8: {
                        this.maxLength = 8;
                        break;
                    }
                    case DATETIME4: {
                        this.maxLength = 4;
                        break;
                    }
                    case DATETIMEN: {
                        this.valueLengthSize = 1;
                        this.maxLength = tDSReader.readUnsignedByte();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                switch (this.maxLength) {
                    case 8: {
                        this.ssType = SSType.DATETIME;
                        this.precision = 23;
                        this.scale = 3;
                        break block0;
                    }
                    case 4: {
                        this.ssType = SSType.SMALLDATETIME;
                        this.precision = 16;
                        this.scale = 0;
                        break block0;
                    }
                }
                tDSReader.throwInvalidTDS();
                break;
            }
            case DECIMALN: {
                bl3 = true;
                this.valueLengthSize = 1;
                this.maxLength = tDSReader.readUnsignedByte();
                this.ssType = SSType.DECIMAL;
                break;
            }
            case NUMERICN: {
                bl3 = true;
                this.valueLengthSize = 1;
                this.maxLength = tDSReader.readUnsignedByte();
                this.ssType = SSType.NUMERIC;
                break;
            }
            case GUID: {
                this.valueLengthSize = 1;
                this.maxLength = tDSReader.readUnsignedByte();
                this.precision = 36;
                this.ssType = SSType.GUID;
                break;
            }
            case BIT1: 
            case BITN: {
                if (TDSType.BIT1 == tDSType) {
                    this.maxLength = 1;
                } else {
                    assert (TDSType.BITN == tDSType);
                    this.valueLengthSize = 1;
                    this.maxLength = tDSReader.readUnsignedByte();
                }
                if (1 != this.maxLength) {
                    tDSReader.throwInvalidTDS();
                }
                this.precision = 1;
                this.ssType = SSType.BIT;
                break;
            }
            case FLOAT8: 
            case FLOAT4: 
            case FLOATN: {
                switch (tDSType) {
                    case FLOAT8: {
                        this.maxLength = 8;
                        break;
                    }
                    case FLOAT4: {
                        this.maxLength = 4;
                        break;
                    }
                    case FLOATN: {
                        this.valueLengthSize = 1;
                        this.maxLength = tDSReader.readUnsignedByte();
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                switch (this.maxLength) {
                    case 8: {
                        this.ssType = SSType.FLOAT;
                        this.precision = 15;
                        break block0;
                    }
                    case 4: {
                        this.ssType = SSType.REAL;
                        this.precision = 7;
                        break block0;
                    }
                }
                tDSReader.throwInvalidTDS();
                break;
            }
            case BIGCHAR: {
                bl = true;
                this.valueLengthSize = 2;
                this.precision = this.maxLength = tDSReader.readUnsignedShort();
                this.ssType = SSType.CHAR;
                break;
            }
            case NCHAR: {
                bl = true;
                bl2 = true;
                this.valueLengthSize = 2;
                this.maxLength = tDSReader.readUnsignedShort();
                this.precision = this.maxLength / 2;
                this.ssType = SSType.NCHAR;
                break;
            }
            case BIGBINARY: {
                this.valueLengthSize = 2;
                this.precision = this.maxLength = tDSReader.readUnsignedShort();
                this.ssType = 80 == n ? SSType.TIMESTAMP : SSType.BINARY;
                break;
            }
            case BIGVARCHAR: {
                bl = true;
                this.valueLengthSize = 2;
                this.maxLength = tDSReader.readUnsignedShort();
                if (65535 == this.maxLength) {
                    this.ssType = SSType.VARCHARMAX;
                    this.precision = Integer.MAX_VALUE;
                    break;
                }
                this.ssType = SSType.VARCHAR;
                this.precision = this.maxLength;
                break;
            }
            case NVARCHAR: {
                bl = true;
                bl2 = true;
                this.valueLengthSize = 2;
                this.maxLength = tDSReader.readUnsignedShort();
                if (65535 == this.maxLength) {
                    this.ssType = SSType.NVARCHARMAX;
                    this.precision = 0x3FFFFFFF;
                    break;
                }
                this.ssType = SSType.NVARCHAR;
                this.precision = this.maxLength / 2;
                break;
            }
            case BIGVARBINARY: {
                this.valueLengthSize = 2;
                this.maxLength = tDSReader.readUnsignedShort();
                if (65535 == this.maxLength) {
                    this.ssType = SSType.VARBINARYMAX;
                    this.precision = Integer.MAX_VALUE;
                    break;
                }
                this.ssType = SSType.VARBINARY;
                this.precision = this.maxLength;
                break;
            }
            case TEXT: {
                bl = true;
                this.valueLengthSize = 4;
                this.maxLength = tDSReader.readInt();
                this.ssType = SSType.TEXT;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            case NTEXT: {
                bl = true;
                bl2 = true;
                this.valueLengthSize = 4;
                this.maxLength = tDSReader.readInt();
                this.ssType = SSType.NTEXT;
                this.precision = 0x3FFFFFFF;
                break;
            }
            case IMAGE: {
                this.valueLengthSize = 4;
                this.maxLength = tDSReader.readInt();
                this.ssType = SSType.IMAGE;
                this.precision = Integer.MAX_VALUE;
                break;
            }
            case UDT: {
                this.udtTDSHeader = new UDTTDSHeader(tDSReader);
                this.precision = this.maxLength = 8000;
                this.ssType = SSType.UDT;
                break;
            }
            case XML: {
                this.xmlTDSHeader = new XMLTDSHeader(tDSReader);
                this.ssType = SSType.XML;
                this.precision = 0x3FFFFFFF;
                this.charset = "UTF-16LE";
                break;
            }
            case SQL_VARIANT: {
                SQLServerException.makeFromDriverError(tDSReader.getConnection(), null, SQLServerException.getErrString("R_variantNotSupported"), "08006", false);
                break;
            }
            default: {
                MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownSSType"));
                Object[] objectArray = new Object[]{new Integer(n2)};
                SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
            }
        }
        if (bl) {
            this.collation = new SQLCollation(tDSReader);
            String string = this.charset = bl2 ? "UTF-16LE" : this.collation.getCharset();
        }
        if (bl3) {
            this.precision = tDSReader.readUnsignedByte();
            this.scale = tDSReader.readUnsignedByte();
        }
    }
}

