/* ---------------------------------------------------------------------- */
/* Views                                                                  */
/* ---------------------------------------------------------------------- */
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'storage_domain_static_view')
BEGIN
	EXEC('CREATE VIEW [storage_domain_static_view] AS SELECT 1 AS one')
END
GO

print 'Step 1 done.'
go

ALTER VIEW [storage_domain_static_view] AS

SELECT     dbo.storage_domain_static.id, 
			dbo.storage_domain_static.storage, 
			dbo.storage_domain_static.storage_name, 
			dbo.storage_pool_iso_map.storage_pool_id, 
			dbo.storage_domain_static.storage_domain_type, 
			dbo.storage_domain_static.storage_type, 
			dbo.storage_domain_static.storage_domain_format_type,
			dbo.storage_pool.name as storage_pool_name
FROM        dbo.storage_domain_static LEFT OUTER JOIN
			storage_pool_iso_map on storage_pool_iso_map.storage_id = storage_domain_static.id
            LEFT OUTER JOIN dbo.storage_pool ON dbo.storage_pool.id = dbo.storage_pool_iso_map.storage_pool_id
GO

print 'Step 2 done.'
go

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'images_storage_domain_view')
BEGIN
	EXEC('CREATE VIEW [images_storage_domain_view] AS SELECT 1 AS one')
END
GO

print 'Step 3 done.'
go


ALTER VIEW [images_storage_domain_view] AS

SELECT     
	dbo.storage_domain_static_view.storage AS storage_path, 
	dbo.storage_domain_static_view.storage_pool_id, 
	dbo.images.image_guid, 
	dbo.images.creation_date, 
    dbo.images.size, 
    dbo.images.it_guid, 
    dbo.images.internal_drive_mapping, 
    dbo.images.description, 
    dbo.images.ParentId, 
    dbo.images.imageStatus, 
    dbo.images.lastModified, 
    dbo.images.app_list, 
    dbo.images.storage_id, 
    dbo.images.vm_snapshot_id, 
    dbo.images.volume_type, 
    dbo.images.volume_format, 
    dbo.images.disk_type, 
    dbo.images.image_group_id,
    dbo.images.disk_interface,
    dbo.images.boot,
    dbo.images.wipe_after_delete,
    dbo.images.propagate_errors,
    dbo.disk_image_dynamic.actual_size,
    dbo.disk_image_dynamic.read_rate,
    dbo.disk_image_dynamic.write_rate
FROM         
	dbo.images 
	LEFT OUTER JOIN
		dbo.storage_domain_static_view 
	ON 
		dbo.images.storage_id = dbo.storage_domain_static_view.id
	left outer join disk_image_dynamic on dbo.images.image_guid = dbo.disk_image_dynamic.image_id
GO

print 'Step 4 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vm_images_view')
BEGIN
	EXEC('CREATE VIEW [vm_images_view] AS SELECT 1 AS one')
END
GO

print 'Step 5 done.'
go

ALTER VIEW [vm_images_view] AS
SELECT     dbo.images_storage_domain_view.storage_path, dbo.images_storage_domain_view.storage_pool_id, dbo.images_storage_domain_view.image_guid, 
                      dbo.images_storage_domain_view.creation_date, dbo.disk_image_dynamic.actual_size, dbo.disk_image_dynamic.read_rate, dbo.disk_image_dynamic.write_rate,
                      dbo.images_storage_domain_view.size, dbo.images_storage_domain_view.it_guid, 
                      dbo.images_storage_domain_view.internal_drive_mapping, dbo.images_storage_domain_view.description, 
                      dbo.images_storage_domain_view.ParentId, dbo.images_storage_domain_view.imageStatus, dbo.images_storage_domain_view.lastModified, 
                      dbo.images_storage_domain_view.app_list, dbo.images_storage_domain_view.storage_id, dbo.images_storage_domain_view.vm_snapshot_id, 
                      dbo.images_storage_domain_view.volume_type, dbo.images_storage_domain_view.image_group_id, dbo.image_vm_map.vm_id AS vm_guid, 
                      dbo.image_vm_map.active, dbo.images_storage_domain_view.volume_format, dbo.images_storage_domain_view.disk_type,
                      dbo.images_storage_domain_view.disk_interface, dbo.images_storage_domain_view.boot, dbo.images_storage_domain_view.wipe_after_delete, dbo.images_storage_domain_view.propagate_errors
FROM         dbo.image_vm_map INNER JOIN
                      dbo.images_storage_domain_view ON dbo.image_vm_map.image_id = dbo.images_storage_domain_view.image_guid
						INNER JOIN disk_image_dynamic ON images_storage_domain_view.image_guid = disk_image_dynamic.image_id
GO

print 'Step 6 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'storage_domains')
BEGIN
	EXEC('CREATE VIEW [storage_domains] AS SELECT 1 AS one')
END
GO

print 'Step 7 done.'
go


ALTER VIEW [storage_domains] AS
SELECT     
		dbo.storage_domain_static.id,
		dbo.storage_domain_static.storage,
		dbo.storage_domain_static.storage_name, 
        dbo.storage_pool_iso_map.storage_pool_id,
		dbo.storage_domain_dynamic.available_disk_size, 
		dbo.storage_domain_dynamic.used_disk_size, 
		dbo.fn_get_disk_commited_value_by_storage(dbo.storage_domain_static.id) as [commited_disk_size],
        dbo.storage_pool_iso_map.status, 
		dbo.storage_pool.name as storage_pool_name,
		dbo.storage_domain_static.storage_type,
		dbo.storage_domain_static.storage_domain_type,
		dbo.storage_domain_static.storage_domain_format_type,
        dbo.storage_pool_iso_map.owner,
        dbo.fn_get_storage_domain_shared_status_by_domain_id(dbo.storage_domain_static.id, dbo.storage_domain_static.storage, 
														dbo.storage_domain_static.storage_type) AS storage_domain_shared_status
FROM    dbo.storage_domain_static 
		INNER JOIN dbo.storage_domain_dynamic ON dbo.storage_domain_static.id = dbo.storage_domain_dynamic.id 
		LEFT OUTER JOIN dbo.storage_pool_iso_map ON dbo.storage_domain_static.id = dbo.storage_pool_iso_map.storage_id 
		LEFT OUTER JOIN dbo.storage_pool ON dbo.storage_pool_iso_map.storage_pool_id = dbo.storage_pool.id
GO

print 'Step 8 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'storage_domain_file_repos')
BEGIN
	EXEC('CREATE VIEW [storage_domain_file_repos] AS SELECT 1 AS one')
END
GO

print 'Step 9 done.'
go


ALTER VIEW [storage_domain_file_repos] AS
SELECT
	dbo.storage_domain_static.id as storage_domain_id,
		dbo.storage_domain_static.storage_domain_type,
        dbo.storage_pool_iso_map.storage_pool_id,
       	dbo.storage_pool_iso_map.status as storage_domain_status,
	dbo.repo_file_meta_data.repo_file_name,
		dbo.repo_file_meta_data.size,
		dbo.repo_file_meta_data.date_created,
		dbo.repo_file_meta_data.last_refreshed,
		dbo.repo_file_meta_data.file_type,
	dbo.vds_dynamic.status as vds_status,
    dbo.storage_pool.status as storage_pool_status 
FROM    dbo.storage_domain_static 
		INNER JOIN dbo.storage_pool_iso_map ON dbo.storage_domain_static.id = dbo.storage_pool_iso_map.storage_id 
		INNER JOIN dbo.storage_pool ON dbo.storage_pool.id = dbo.storage_pool_iso_map.storage_pool_id 
		INNER JOIN dbo.vds_dynamic ON dbo.vds_dynamic.vds_id = dbo.storage_pool.spm_vds_id 
		LEFT OUTER JOIN dbo.repo_file_meta_data ON dbo.storage_pool_iso_map.storage_id = dbo.repo_file_meta_data.repo_domain_id 
GO

print 'Step 10 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'storage_domains_without_storage_pools')
BEGIN
	EXEC('CREATE VIEW [storage_domains_without_storage_pools] AS SELECT 1 AS one')
END
GO

print 'Step 11 done.'
go


ALTER VIEW [storage_domains_without_storage_pools] AS
SELECT  
		dbo.storage_domain_static.id, dbo.storage_domain_static.storage, dbo.storage_domain_static.storage_name, 
		dbo.storage_domain_static.storage_type, dbo.storage_domain_static.storage_domain_type,
		dbo.storage_domain_static.storage_domain_format_type,
		null as status, null as owner, null as storage_pool_id, null as storage_pool_name,
		dbo.storage_domain_dynamic.available_disk_size, 
		dbo.storage_domain_dynamic.used_disk_size, 
		dbo.fn_get_disk_commited_value_by_storage(dbo.storage_domain_static.id) as [commited_disk_size],
        dbo.fn_get_storage_domain_shared_status_by_domain_id(dbo.storage_domain_static.id, dbo.storage_domain_static.storage,
														dbo.storage_domain_static.storage_type) AS storage_domain_shared_status
FROM
		dbo.storage_domain_static 
		INNER JOIN dbo.storage_domain_dynamic ON dbo.storage_domain_static.id = dbo.storage_domain_dynamic.id 
GO

print 'Step 12 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vm_templates_view')
BEGIN
	EXEC('CREATE VIEW [vm_templates_view] AS SELECT 1 AS one')
END
GO

print 'Step 13 done.'
go


ALTER VIEW [vm_templates_view] AS

SELECT     
	dbo.vm_templates.vmt_guid, 
	dbo.vm_templates.name, 
	dbo.vm_templates.mem_size_mb, 
	dbo.vm_templates.os, 
	dbo.vm_templates.creation_date, 
	dbo.vm_templates.child_count, 
	dbo.vm_templates.num_of_sockets, 
	dbo.vm_templates.cpu_per_socket, 
	dbo.vm_templates.num_of_sockets  * dbo.vm_templates.cpu_per_socket as num_of_cpus,
	dbo.vm_templates.description, 
	dbo.vm_templates.vds_group_id, 
    dbo.vm_templates.domain, 
    dbo.vm_templates.num_of_monitors, 
    dbo.vm_templates.status, 
    dbo.vm_templates.usb_policy, 
    dbo.vm_templates.time_zone, 
    dbo.vm_templates.is_auto_suspend, 
    dbo.vm_templates.fail_back, 
    dbo.vds_groups.name AS vds_group_name,
	dbo.vm_templates.vm_type,
	dbo.vm_templates.hypervisor_type,
	dbo.vm_templates.operation_mode,
	dbo.vm_templates.nice_level,
	dbo.storage_pool.id AS storage_pool_id, 
	dbo.storage_pool.name AS storage_pool_name,
	dbo.vm_templates.default_boot_sequence,
	dbo.vm_templates.default_display_type,
	dbo.vm_templates.priority,
	dbo.vm_templates.auto_startup,
	dbo.vm_templates.is_stateless,
	dbo.vm_templates.iso_path,
	dbo.vm_templates.origin,
    dbo.vm_templates.initrd_url,
    dbo.vm_templates.kernel_url,
    dbo.vm_templates.kernel_params

FROM       dbo.vm_templates  INNER JOIN
                    dbo.vds_groups ON dbo.vm_templates.vds_group_id = dbo.vds_groups.vds_group_id
                    left outer JOIN 
					dbo.storage_pool ON dbo.storage_pool.id = dbo.vds_groups.storage_pool_id

GO

print 'Step 14 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vm_templates_storage_domain')
BEGIN
	EXEC('CREATE VIEW [vm_templates_storage_domain] AS SELECT 1 AS one')
END
GO

print 'Step 15 done.'
go


ALTER VIEW [vm_templates_storage_domain] AS

SELECT     dbo.vm_templates.vmt_guid, dbo.vm_templates.name, dbo.vm_templates.mem_size_mb, dbo.vm_templates.os, dbo.vm_templates.creation_date,
                      dbo.vm_templates.child_count, dbo.vm_templates.num_of_sockets, dbo.vm_templates.cpu_per_socket,
                      dbo.vm_templates.num_of_sockets * dbo.vm_templates.cpu_per_socket AS num_of_cpus, dbo.vm_templates.description,
                      dbo.vm_templates.vds_group_id, dbo.vm_templates.domain, dbo.vm_templates.num_of_monitors, dbo.vm_templates.status,
                      dbo.vm_templates.usb_policy, dbo.vm_templates.time_zone, dbo.vm_templates.is_auto_suspend, dbo.vm_templates.fail_back,
                      dbo.vds_groups.name AS vds_group_name, dbo.vm_templates.vm_type, dbo.vm_templates.hypervisor_type, dbo.vm_templates.operation_mode,
                      dbo.vm_templates.nice_level, dbo.storage_pool.id AS storage_pool_id, dbo.storage_pool.name AS storage_pool_name,
                      dbo.vm_templates.default_boot_sequence, dbo.vm_templates.default_display_type, dbo.vm_templates.priority, dbo.vm_templates.auto_startup,
                      dbo.vm_templates.is_stateless, dbo.vm_templates.iso_path, dbo.vm_templates.origin, dbo.vm_templates.initrd_url, dbo.vm_templates.kernel_url,
                      dbo.vm_templates.kernel_params, dbo.images.storage_id
FROM         dbo.vm_templates INNER JOIN
                      dbo.vds_groups ON dbo.vm_templates.vds_group_id = dbo.vds_groups.vds_group_id LEFT OUTER JOIN
                      dbo.storage_pool ON dbo.storage_pool.id = dbo.vds_groups.storage_pool_id INNER JOIN
                      dbo.vm_template_image_map ON dbo.vm_template_image_map.vmt_guid = dbo.vm_templates.vmt_guid LEFT JOIN
                      dbo.images ON dbo.images.image_guid = dbo.vm_template_image_map.it_guid
UNION
SELECT     vm_templates_1.vmt_guid, vm_templates_1.name, vm_templates_1.mem_size_mb, vm_templates_1.os, vm_templates_1.creation_date,
                      vm_templates_1.child_count, vm_templates_1.num_of_sockets, vm_templates_1.cpu_per_socket,
                      vm_templates_1.num_of_sockets * vm_templates_1.cpu_per_socket AS num_of_cpus, vm_templates_1.description, vm_templates_1.vds_group_id,
                      vm_templates_1.domain, vm_templates_1.num_of_monitors, vm_templates_1.status, vm_templates_1.usb_policy, vm_templates_1.time_zone,
                      vm_templates_1.is_auto_suspend, vm_templates_1.fail_back, vds_groups_1.name AS vds_group_name, vm_templates_1.vm_type,
                      vm_templates_1.hypervisor_type, vm_templates_1.operation_mode, vm_templates_1.nice_level, storage_pool_1.id AS storage_pool_id,
                      storage_pool_1.name AS storage_pool_name, vm_templates_1.default_boot_sequence, vm_templates_1.default_display_type,
                      vm_templates_1.priority, vm_templates_1.auto_startup, vm_templates_1.is_stateless, vm_templates_1.iso_path, vm_templates_1.origin,
                      vm_templates_1.initrd_url, vm_templates_1.kernel_url, vm_templates_1.kernel_params,
                      dbo.image_group_storage_domain_map.storage_domain_id AS storage_id
FROM         dbo.vm_templates AS vm_templates_1 INNER JOIN
                      dbo.vds_groups AS vds_groups_1 ON vm_templates_1.vds_group_id = vds_groups_1.vds_group_id LEFT OUTER JOIN
                      dbo.storage_pool AS storage_pool_1 ON storage_pool_1.id = vds_groups_1.storage_pool_id INNER JOIN
                      dbo.vm_template_image_map AS vm_template_image_map_1 ON vm_template_image_map_1.vmt_guid = vm_templates_1.vmt_guid INNER JOIN
                      dbo.images AS images_1 ON images_1.image_guid = vm_template_image_map_1.it_guid INNER JOIN
                      dbo.image_group_storage_domain_map ON dbo.image_group_storage_domain_map.image_group_id = images_1.image_group_id
GO

print 'Step 16 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vm_template_disk')
BEGIN
	EXEC('CREATE VIEW [vm_template_disk] AS SELECT 1 AS one')
END
GO

print 'Step 17 done.'
go


ALTER VIEW [vm_template_disk] AS

SELECT     
	dbo.vm_template_image_map.it_guid AS vtim_it_guid, 
	dbo.vm_template_image_map.vmt_guid, 
	dbo.vm_template_image_map.internal_drive_mapping, 
	dbo.image_templates.it_guid, 
	dbo.image_templates.os, 
	dbo.image_templates.os_version, 
	dbo.image_templates.creation_date, 
	dbo.image_templates.size, 
	dbo.image_templates.description,
	dbo.image_templates.bootable
FROM         
	dbo.vm_template_image_map 
	INNER JOIN
     	dbo.image_templates 
	ON 
	dbo.vm_template_image_map.it_guid = dbo.image_templates.it_guid
GO

print 'Step 18 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vm_pool_map_view')
BEGIN
	EXEC('CREATE VIEW [vm_pool_map_view] AS SELECT 1 AS one')
END
GO

print 'Step 19 done.'
go


ALTER VIEW [vm_pool_map_view] AS
SELECT  
dbo.vm_pool_map.vm_guid,
dbo.vm_pool_map.vm_pool_id,
dbo.vm_pools.vm_pool_name
from dbo.vm_pool_map 
	INNER JOIN dbo.vm_pools 
	ON dbo.vm_pool_map.vm_pool_id = vm_pools.vm_pool_id
GO

print 'Step 20 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'tags_vm_pool_map_view')
BEGIN
	EXEC('CREATE VIEW [tags_vm_pool_map_view] AS SELECT 1 AS one')
END
GO

print 'Step 21 done.'
go


ALTER VIEW [dbo].[tags_vm_pool_map_view] AS
SELECT		dbo.tags.tag_id, 
			dbo.tags.tag_name, 
			dbo.tags.parent_id, 
			dbo.tags.readonly, dbo.tags.type, 
			dbo.tags_vm_pool_map.vm_pool_id
FROM        dbo.tags INNER JOIN
            dbo.tags_vm_pool_map ON dbo.tags.tag_id = dbo.tags_vm_pool_map.tag_id
GO

print 'Step 22 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'tags_vm_map_view')
BEGIN
	EXEC('CREATE VIEW [tags_vm_map_view] AS SELECT 1 AS one')
END
GO

print 'Step 23 done.'
go


ALTER VIEW [tags_vm_map_view] AS
SELECT     dbo.tags.tag_id, 
		   dbo.tags.tag_name, 
		   dbo.tags.parent_id,
		   dbo.tags.readonly,
		   dbo.tags.type,
           dbo.tags_vm_map.vm_id
FROM       dbo.tags INNER JOIN
           dbo.tags_vm_map ON dbo.tags.tag_id = dbo.tags_vm_map.tag_id
GO

print 'Step 24 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'tags_vds_map_view')
BEGIN
	EXEC('CREATE VIEW [tags_vds_map_view] AS SELECT 1 AS one')
END
GO

print 'Step 25 done.'
go


ALTER VIEW [tags_vds_map_view] AS
SELECT     dbo.tags.tag_id, 
		   dbo.tags.tag_name, 
		   dbo.tags.parent_id,
		   dbo.tags.readonly,
		   dbo.tags.type,
           dbo.tags_vds_map.vds_id
FROM       dbo.tags INNER JOIN
           dbo.tags_vds_map ON dbo.tags.tag_id = dbo.tags_vds_map.tag_id
GO

print 'Step 26 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'tags_user_map_view')
BEGIN
	EXEC('CREATE VIEW [tags_user_map_view] AS SELECT 1 AS one')
END
GO

print 'Step 27 done.'
go


ALTER VIEW [tags_user_map_view] AS
SELECT     dbo.tags.tag_id, 
           dbo.tags.tag_name, 
		   dbo.tags.parent_id,
		   dbo.tags.readonly,
		   dbo.tags.type,
           dbo.tags_user_map.user_id
FROM       dbo.tags INNER JOIN
           dbo.tags_user_map ON dbo.tags.tag_id = dbo.tags_user_map.tag_id
GO

print 'Step 28 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'tags_user_group_map_view')
BEGIN
	EXEC('CREATE VIEW [tags_user_group_map_view] AS SELECT 1 AS one')
END
GO

print 'Step 29 done.'
go

ALTER VIEW [tags_user_group_map_view] AS
SELECT     dbo.tags.tag_id, 
			dbo.tags.tag_name,
			dbo.tags.parent_id,
			dbo.tags.readonly,
		   dbo.tags.type,
			 dbo.tags_user_group_map.group_id
FROM         dbo.tags_user_group_map INNER JOIN
                      dbo.tags ON dbo.tags_user_group_map.tag_id = dbo.tags.tag_id
GO

print 'Step 30 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vms')
BEGIN
	EXEC('CREATE VIEW [vms] AS SELECT 1 AS one')
END
GO

print 'Step 31 done.'
go

ALTER VIEW [vms] AS
SELECT     dbo.vm_static.vm_name, dbo.vm_static.mem_size_mb AS vm_mem_size_mb, dbo.vm_static.nice_level,
                      dbo.vm_static.vmt_guid, dbo.vm_static.os AS vm_os, dbo.vm_static.description AS vm_description, dbo.vm_static.vds_group_id, 
                      dbo.vm_static.domain AS vm_domain, dbo.vm_static.creation_date AS vm_creation_date, dbo.vm_static.auto_startup, dbo.vm_static.is_stateless, dbo.vm_static.dedicated_vm_for_vds,
                      dbo.vm_static.fail_back as fail_back, dbo.vm_static.default_boot_sequence as default_boot_sequence, dbo.vm_static.vm_type as vm_type,
					  dbo.vm_static.hypervisor_type, dbo.vm_static.operation_mode, dbo.vds_groups.name AS vds_group_name, dbo.vds_groups.selection_algorithm, vds_groups.transparent_hugepages,
					  dbo.storage_pool.id as storage_pool_id, dbo.storage_pool.name as storage_pool_name,
                      dbo.vds_groups.description AS vds_group_description, dbo.vm_templates.name AS vmt_name,
                      dbo.vm_templates.mem_size_mb AS vmt_mem_size_mb, dbo.vm_templates.os AS vmt_os, dbo.vm_templates.creation_date AS vmt_creation_date,
                      dbo.vm_templates.child_count AS vmt_child_count, dbo.vm_templates.num_of_sockets AS vmt_num_of_sockets,
                      dbo.vm_templates.cpu_per_socket AS vmt_cpu_per_socket, dbo.vm_templates.num_of_sockets  * dbo.vm_templates.cpu_per_socket as vmt_num_of_cpus, 
                      dbo.vm_templates.description AS vmt_description, dbo.vm_dynamic.status, dbo.vm_dynamic.vm_ip, dbo.vm_dynamic.vm_host, 
                      dbo.vm_dynamic.vm_pid, dbo.vm_dynamic.vm_last_up_time, dbo.vm_dynamic.vm_last_boot_time, dbo.vm_dynamic.guest_cur_user_name, 
                      dbo.vm_dynamic.guest_last_login_time, dbo.vm_dynamic.guest_cur_user_id, dbo.vm_dynamic.guest_last_logout_time, dbo.vm_dynamic.guest_os, 
                      dbo.vm_dynamic.run_on_vds, dbo.vm_dynamic.migrating_to_vds, dbo.vm_dynamic.app_list, dbo.vm_dynamic.display, dbo.vm_dynamic.hibernation_vol_handle,
                      dbo.vm_pool_map_view.vm_pool_name, dbo.vm_pool_map_view.vm_pool_id, dbo.vm_static.vm_guid, dbo.vm_static.num_of_monitors, dbo.vm_static.is_initialized, 
                      dbo.vm_static.is_auto_suspend, dbo.vm_static.num_of_sockets, dbo.vm_static.cpu_per_socket, dbo.vm_static.usb_policy, dbo.vm_dynamic.acpi_enable, dbo.vm_dynamic.session, 
                      dbo.vm_static.num_of_sockets  * dbo.vm_static.cpu_per_socket as num_of_cpus, 
                      dbo.vm_dynamic.display_ip, dbo.vm_dynamic.display_type, dbo.vm_dynamic.kvm_enable, dbo.vm_dynamic.boot_sequence, 
                      dbo.vm_dynamic.display_secure_port, dbo.vm_dynamic.utc_diff, dbo.vm_dynamic.last_vds_run_on,
					  dbo.vm_dynamic.client_ip,dbo.vm_dynamic.guest_requested_memory, dbo.vm_static.time_zone, dbo.vm_statistics.cpu_user, dbo.vm_statistics.cpu_sys, 
                      dbo.vm_statistics.elapsed_time, dbo.vm_statistics.usage_network_percent, 
                      dbo.vm_statistics.usage_mem_percent, dbo.vm_statistics.usage_cpu_percent, dbo.vds_static.vds_name AS run_on_vds_name, dbo.vds_groups.cpu_name as vds_group_cpu_name,
                      dbo.vm_static.default_display_type, dbo.vm_static.priority,dbo.vm_static.iso_path, dbo.vm_static.origin, dbo.vds_groups.compatibility_version AS vds_group_compatibility_version,
                      dbo.vm_static.initrd_url, dbo.vm_static.kernel_url, dbo.vm_static.kernel_params, dbo.vm_dynamic.pause_status, dbo.vm_dynamic.exit_message, dbo.vm_dynamic.exit_status,dbo.vm_static.migration_support,dbo.vm_static.predefined_properties,dbo.vm_static.userdefined_properties,dbo.vm_static.min_allocated_mem
FROM         dbo.vm_static INNER JOIN
                      dbo.vm_dynamic ON dbo.vm_static.vm_guid = dbo.vm_dynamic.vm_guid INNER JOIN
                      dbo.vm_templates ON dbo.vm_static.vmt_guid = dbo.vm_templates.vmt_guid INNER JOIN
                      dbo.vm_statistics ON dbo.vm_static.vm_guid = dbo.vm_statistics.vm_guid INNER JOIN
					  dbo.vds_groups ON dbo.vm_static.vds_group_id = dbo.vds_groups.vds_group_id LEFT OUTER JOIN
					  dbo.storage_pool ON dbo.vm_static.vds_group_id = dbo.vds_groups.vds_group_id 
						and dbo.vds_groups.storage_pool_id = dbo.storage_pool.id LEFT OUTER JOIN
                      dbo.vds_static ON dbo.vm_dynamic.run_on_vds = dbo.vds_static.vds_id LEFT OUTER JOIN
                      dbo.vm_pool_map_view ON dbo.vm_static.vm_guid = dbo.vm_pool_map_view.vm_guid
GO

print 'Step 32 done.'
go



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vms_with_tags')
BEGIN
	EXEC('CREATE VIEW [vms_with_tags] AS SELECT 1 AS one')
END
GO

print 'Step 33 done.'
go

ALTER VIEW [vms_with_tags] AS
SELECT     dbo.vms.vm_name, dbo.vms.vm_mem_size_mb, dbo.vms.nice_level, dbo.vms.vmt_guid, dbo.vms.vm_os, dbo.vms.vm_description,
                      dbo.vms.vds_group_id, dbo.vms.vm_domain, dbo.vms.vm_creation_date, dbo.vms.auto_startup, dbo.vms.is_stateless,
                      dbo.vms.dedicated_vm_for_vds, dbo.vms.fail_back, dbo.vms.default_boot_sequence, dbo.vms.vm_type, dbo.vms.hypervisor_type,
                      dbo.vms.operation_mode, dbo.vms.vds_group_name, dbo.vms.selection_algorithm, dbo.vms.storage_pool_id, dbo.vms.storage_pool_name,
                      dbo.vms.vds_group_description, dbo.vms.vmt_name, dbo.vms.vmt_mem_size_mb, dbo.vms.vmt_os, dbo.vms.vmt_creation_date,
                      dbo.vms.vmt_child_count, dbo.vms.vmt_num_of_sockets, dbo.vms.vmt_cpu_per_socket, dbo.vms.vmt_description, dbo.vms.status, dbo.vms.vm_ip,
                      dbo.vms.vm_host, dbo.vms.vmt_num_of_sockets * dbo.vms.vmt_cpu_per_socket AS vmt_num_of_cpus, dbo.vms.vm_pid, dbo.vms.vm_last_up_time,
                      dbo.vms.vm_last_boot_time, dbo.vms.guest_cur_user_name, dbo.vms.guest_last_login_time, dbo.vms.guest_cur_user_id,
                      dbo.vms.guest_last_logout_time, dbo.vms.guest_os, dbo.vms.run_on_vds, dbo.vms.migrating_to_vds, dbo.vms.app_list, dbo.vms.display,
                      dbo.vms.hibernation_vol_handle, dbo.vms.vm_pool_name, dbo.vms.vm_pool_id, dbo.vms.vm_guid, dbo.vms.num_of_monitors,
                      dbo.vms.is_initialized, dbo.vms.is_auto_suspend, dbo.vms.num_of_sockets, dbo.vms.cpu_per_socket, dbo.vms.usb_policy, dbo.vms.acpi_enable,
                      dbo.vms.session, dbo.vms.num_of_sockets * dbo.vms.cpu_per_socket AS num_of_cpus, dbo.vms.display_ip, dbo.vms.display_type,
                      dbo.vms.kvm_enable, dbo.vms.boot_sequence, dbo.vms.display_secure_port, dbo.vms.utc_diff, dbo.vms.last_vds_run_on, dbo.vms.client_ip,
                      dbo.vms.guest_requested_memory, dbo.vms.time_zone, dbo.vms.cpu_user, dbo.vms.cpu_sys, dbo.vms.elapsed_time,
                      dbo.vms.usage_network_percent, dbo.vms.usage_mem_percent, dbo.vms.usage_cpu_percent, dbo.vms.run_on_vds_name,
                      dbo.vms.vds_group_cpu_name, dbo.tags_vm_map_view.tag_name, dbo.tags_vm_map_view.tag_id, dbo.vms.default_display_type, dbo.vms.priority,
                      dbo.vms.vds_group_compatibility_version, dbo.vms.initrd_url, dbo.vms.kernel_url, dbo.vms.kernel_params, dbo.vms.pause_status,
                      dbo.vms.exit_status, dbo.vms.exit_message, dbo.vms.min_allocated_mem, dbo.storage_domain_static.id AS storage_id
FROM         dbo.vms LEFT OUTER JOIN
                      dbo.tags_vm_map_view ON dbo.vms.vm_guid = dbo.tags_vm_map_view.vm_id LEFT OUTER JOIN
                      dbo.image_vm_map ON dbo.vms.vm_guid = dbo.image_vm_map.vm_id LEFT OUTER JOIN
                      dbo.images ON dbo.images.image_guid = dbo.image_vm_map.image_id LEFT OUTER JOIN
                      dbo.storage_domain_static ON dbo.storage_domain_static.id = dbo.images.storage_id
GO

print 'Step 34 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'server_vms')
BEGIN
	EXEC('CREATE VIEW [server_vms] AS SELECT 1 AS one')
END
GO

print 'Step 35 done.'
go

ALTER VIEW [server_vms] as
SELECT *    
FROM dbo.vms
WHERE [vm_type] = '1'
GO

print 'Step 36 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'desktop_vms')
BEGIN
	EXEC('CREATE VIEW [desktop_vms] AS SELECT 1 AS one')
END
GO

print 'Step 37 done.'
go

ALTER VIEW [desktop_vms] as
SELECT *    
FROM dbo.vms
WHERE [vm_type] = '0'
GO

print 'Step 38 done.'
go





IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vds')
BEGIN
	EXEC('CREATE VIEW [vds] AS SELECT 1 AS one')
END
GO

print 'Step 39 done.'
go

ALTER VIEW [vds] as
SELECT     dbo.vds_groups.vds_group_id, dbo.vds_groups.name AS vds_group_name, dbo.vds_groups.description AS vds_group_description, 
                      dbo.vds_groups.selection_algorithm, dbo.vds_static.vds_id, dbo.vds_static.vds_name, dbo.vds_static.ip, dbo.vds_static.vds_unique_id, 
                      dbo.vds_static.host_name, dbo.vds_static.port, dbo.vds_static.vds_strength, dbo.vds_static.server_SSL_enabled, dbo.vds_static.vds_type, 
                      dbo.vds_static.pm_type, dbo.vds_static.pm_user, dbo.vds_static.pm_password, dbo.vds_static.pm_port, 
                      dbo.vds_static.pm_options, dbo.vds_static.pm_enabled, dbo.vds_dynamic.hooks,dbo.vds_dynamic.status, dbo.vds_dynamic.cpu_cores, dbo.vds_dynamic.cpu_model, 
                      dbo.vds_dynamic.cpu_speed_mh, dbo.vds_dynamic.if_total_speed, dbo.vds_dynamic.kvm_enabled, dbo.vds_dynamic.physical_mem_mb, 
                      dbo.vds_dynamic.pending_vcpus_count, dbo.vds_dynamic.pending_vmem_size,dbo.vds_dynamic.mem_commited, dbo.vds_dynamic.vm_active, dbo.vds_dynamic.vm_count, 
                      dbo.vds_dynamic.vm_migrating, dbo.vds_dynamic.vms_cores_count, dbo.vds_dynamic.cpu_over_commit_time_stamp, 
                      dbo.vds_dynamic.hypervisor_type, dbo.vds_dynamic.net_config_dirty, dbo.vds_groups.high_utilization, dbo.vds_groups.low_utilization, 
                      dbo.vds_groups.max_vds_memory_over_commit, dbo.vds_groups.cpu_over_commit_duration_minutes, 
                      dbo.storage_pool.id AS storage_pool_id, dbo.storage_pool.name AS storage_pool_name, dbo.vds_dynamic.reserved_mem, 
                      dbo.vds_dynamic.guest_overhead, dbo.vds_dynamic.software_version, dbo.vds_dynamic.version_name, dbo.vds_dynamic.build_name, 
                      dbo.vds_dynamic.previous_status, dbo.vds_statistics.cpu_idle, dbo.vds_statistics.cpu_load, dbo.vds_statistics.cpu_sys, dbo.vds_statistics.cpu_user,
                      dbo.vds_statistics.usage_mem_percent, dbo.vds_statistics.usage_cpu_percent, dbo.vds_statistics.usage_network_percent, 
                      dbo.vds_statistics.mem_available, dbo.vds_statistics.mem_shared, dbo.vds_statistics.swap_free,  
					  dbo.vds_statistics.swap_total,  dbo.vds_statistics.ksm_cpu_percent,  dbo.vds_statistics.ksm_pages,  dbo.vds_statistics.ksm_state,  
                      dbo.vds_dynamic.cpu_flags,dbo.vds_groups.cpu_name AS vds_group_cpu_name, dbo.vds_dynamic.cpu_sockets, dbo.vds_spm_id_map.vds_spm_id, 
                      CASE WHEN dbo.storage_pool.spm_vds_id = dbo.vds_static.vds_id THEN CASE WHEN dbo.storage_pool.status = 5 THEN 1 ELSE 2 END ELSE 0 END AS
                      spm_status, dbo.vds_dynamic.supported_cluster_levels, dbo.vds_dynamic.supported_rhevms, dbo.vds_groups.compatibility_version AS vds_group_compatibility_version,
                      dbo.vds_dynamic.host_os, dbo.vds_dynamic.kvm_version, dbo.vds_dynamic.spice_version, dbo.vds_dynamic.kernel_version, dbo.vds_dynamic.iscsi_initiator_name,
                      dbo.vds_dynamic.transparent_hugepages_state, dbo.vds_dynamic.anonymous_hugepages, dbo.vds_dynamic.non_operational_reason
FROM         dbo.vds_groups INNER JOIN
                      dbo.vds_static ON dbo.vds_groups.vds_group_id = dbo.vds_static.vds_group_id INNER JOIN
                      dbo.vds_dynamic ON dbo.vds_static.vds_id = dbo.vds_dynamic.vds_id INNER JOIN
                      dbo.vds_statistics ON dbo.vds_static.vds_id = dbo.vds_statistics.vds_id LEFT OUTER JOIN
                      dbo.storage_pool ON dbo.vds_groups.storage_pool_id = dbo.storage_pool.id LEFT OUTER JOIN
                      dbo.vds_spm_id_map ON dbo.vds_static.vds_id = dbo.vds_spm_id_map.vds_id
GO

print 'Step 40 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vds_with_tags')
BEGIN
	EXEC('CREATE VIEW [vds_with_tags] AS SELECT 1 AS one')
END
GO

print 'Step 41 done.'
go

ALTER VIEW [vds_with_tags] as
SELECT     dbo.vds_groups.vds_group_id, dbo.vds_groups.name AS vds_group_name, dbo.vds_groups.description AS vds_group_description,
                      dbo.vds_groups.selection_algorithm, dbo.vds_static.vds_id, dbo.vds_static.vds_name, dbo.vds_static.ip, dbo.vds_static.vds_unique_id,
                      dbo.vds_static.host_name, dbo.vds_static.port, dbo.vds_static.vds_strength, dbo.vds_static.server_SSL_enabled, dbo.vds_static.vds_type,
                      dbo.vds_static.pm_type, dbo.vds_static.pm_user, dbo.vds_static.pm_password, dbo.vds_static.pm_port,
                      dbo.vds_static.pm_options, dbo.vds_static.pm_enabled, dbo.vds_dynamic.hooks, dbo.vds_dynamic.status, dbo.vds_dynamic.cpu_cores,
                      dbo.vds_dynamic.cpu_model, dbo.vds_dynamic.cpu_speed_mh, dbo.vds_dynamic.if_total_speed, dbo.vds_dynamic.kvm_enabled,
                      dbo.vds_dynamic.physical_mem_mb, dbo.vds_dynamic.pending_vcpus_count, dbo.vds_dynamic.pending_vmem_size,
                      dbo.vds_dynamic.mem_commited, dbo.vds_dynamic.vm_active, dbo.vds_dynamic.vm_count, dbo.vds_dynamic.vm_migrating,
                      dbo.vds_dynamic.vms_cores_count, dbo.vds_dynamic.cpu_over_commit_time_stamp, dbo.vds_dynamic.hypervisor_type,
                      dbo.vds_dynamic.net_config_dirty, dbo.vds_groups.high_utilization, dbo.vds_groups.low_utilization,
                      dbo.vds_groups.max_vds_memory_over_commit, dbo.vds_groups.cpu_over_commit_duration_minutes, 
                      dbo.storage_pool.id AS storage_pool_id, dbo.storage_pool.name AS storage_pool_name, dbo.tags_vds_map_view.tag_name,
                      dbo.tags_vds_map_view.tag_id, dbo.vds_dynamic.reserved_mem, dbo.vds_dynamic.guest_overhead, dbo.vds_dynamic.software_version,
                      dbo.vds_dynamic.version_name, dbo.vds_dynamic.build_name, dbo.vds_dynamic.previous_status, dbo.vds_statistics.cpu_idle,
                      dbo.vds_statistics.cpu_load, dbo.vds_statistics.cpu_sys, dbo.vds_statistics.cpu_user, dbo.vds_statistics.usage_mem_percent,
                      dbo.vds_statistics.usage_cpu_percent, dbo.vds_statistics.usage_network_percent, dbo.vds_statistics.mem_available,
                      dbo.vds_statistics.mem_shared, dbo.vds_statistics.swap_free, dbo.vds_statistics.swap_total, dbo.vds_statistics.ksm_cpu_percent,
                      dbo.vds_statistics.ksm_pages, dbo.vds_statistics.ksm_state, dbo.vds_dynamic.cpu_flags, dbo.vds_groups.cpu_name AS vds_group_cpu_name,
                      dbo.vds_dynamic.cpu_sockets, dbo.vds_spm_id_map.vds_spm_id,
                      CASE WHEN dbo.storage_pool.spm_vds_id = dbo.vds_static.vds_id THEN CASE WHEN dbo.storage_pool.status = 5 THEN 1 ELSE 2 END ELSE 0 END AS
                       spm_status, dbo.vds_dynamic.supported_cluster_levels, dbo.vds_dynamic.supported_rhevms,
                      dbo.vds_groups.compatibility_version AS vds_group_compatibility_version, dbo.vds_dynamic.host_os, dbo.vds_dynamic.kvm_version,
                      dbo.vds_dynamic.spice_version, dbo.vds_dynamic.kernel_version, dbo.vds_dynamic.iscsi_initiator_name,
                      dbo.vds_dynamic.transparent_hugepages_state, dbo.vds_dynamic.anonymous_hugepages, dbo.vds_dynamic.non_operational_reason,
                      dbo.storage_pool_iso_map.storage_id
FROM         dbo.vds_groups INNER JOIN
                      dbo.vds_static ON dbo.vds_groups.vds_group_id = dbo.vds_static.vds_group_id INNER JOIN
                      dbo.vds_dynamic ON dbo.vds_static.vds_id = dbo.vds_dynamic.vds_id INNER JOIN
                      dbo.vds_statistics ON dbo.vds_static.vds_id = dbo.vds_statistics.vds_id LEFT OUTER JOIN
                      dbo.storage_pool ON dbo.vds_groups.storage_pool_id = dbo.storage_pool.id LEFT OUTER JOIN
                      dbo.tags_vds_map_view ON dbo.vds_static.vds_id = dbo.tags_vds_map_view.vds_id LEFT OUTER JOIN
                      dbo.vds_spm_id_map ON dbo.vds_static.vds_id = dbo.vds_spm_id_map.vds_id LEFT OUTER JOIN
                      dbo.storage_pool_iso_map ON dbo.storage_pool_iso_map.storage_pool_id = dbo.storage_pool.id

GO

print 'Step 42 done.'
go



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'users_and_groups_to_vm_pool_map_view')
BEGIN
	EXEC('CREATE VIEW [users_and_groups_to_vm_pool_map_view] AS SELECT 1 AS one')
END
GO

print 'Step 43 done.'
go


ALTER VIEW [users_and_groups_to_vm_pool_map_view] AS
select	p.vm_pool_id, p.vm_pool_name, per.ad_element_id as user_id, tMap.start_time AS [from], tMap.end_time AS [to]
FROM    dbo.vm_pools AS p 
	INNER JOIN dbo.permissions as per on per.object_id = p.vm_pool_id
	left outer JOIN dbo.time_lease_vm_pool_map as tMap on tMap.vm_pool_id = p.vm_pool_id
GO

print 'Step 44 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vdc_users')
BEGIN
	EXEC('CREATE VIEW [vdc_users] AS SELECT 1 AS one')
END
GO

print 'Step 45 done.'
go


ALTER VIEW [vdc_users] AS

SELECT     'user' AS user_group, users_1.name, users_1.user_id, users_1.surname, users_1.domain, users_1.username, users_1.groups, users_1.department, 
                      users_1.role, users_1.user_icon_path, users_1.desktop_device, users_1.email, users_1.note, users_1.status, 0 AS vm_admin, 
                      users_1.session_count, users_1.last_admin_check_status	
FROM         dbo.users AS users_1 
UNION
SELECT     'group' AS user_group, dbo.ad_groups.name, dbo.ad_groups.id, '' AS surname, dbo.ad_groups.domain AS domain, '' AS username, '' AS groups, '' AS department, '' AS role, 
                      '' AS user_icon_path, '' AS desktop_device, '' AS email, '' AS note, dbo.ad_groups.status, 1 AS vm_admin, 0 AS session_count, '' AS last_admin_check_status
FROM         dbo.ad_groups 
GO

print 'Step 46 done.'
go


-- create the new vdc_users_with_tags view with no use of the tag_permission_map
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vdc_users_with_tags')
BEGIN
	EXEC('CREATE VIEW [vdc_users_with_tags] AS SELECT 1 AS one')
END
GO

print 'Step 47 done.'
go

ALTER VIEW [dbo].[vdc_users_with_tags] AS

SELECT     users_1.user_group, users_1.name, '00000000-0000-0000-0000-000000000000' AS vm_guid, users_1.user_id, users_1.surname, users_1.domain,
                      users_1.username, users_1.groups, users_1.department, users_1.role as role, roles1.name AS mla_role, users_1.user_icon_path, users_1.desktop_device, users_1.email,
                      users_1.note, users_1.status, users_1.vm_admin, tags_user_map_view_1.tag_name, tags_user_map_view_1.tag_id, users_1.session_count,
                      pools.vm_pool_name
FROM         dbo.vdc_users AS users_1 LEFT OUTER JOIN
                      dbo.users_and_groups_to_vm_pool_map_view AS pools ON users_1.user_id = pools.user_id LEFT OUTER JOIN
                      dbo.permissions ON users_1.user_id = dbo.permissions.ad_element_id LEFT OUTER JOIN
                      dbo.tags ON dbo.tags.type = 1 LEFT OUTER JOIN
                      dbo.tags_user_map_view AS tags_user_map_view_1 ON users_1.user_id = tags_user_map_view_1.user_id LEFT OUTER JOIN
                      dbo.roles AS roles1 ON roles1.id = dbo.permissions.role_id
WHERE     (users_1.user_group = 'user')
UNION
SELECT     users_2.user_group, users_2.name, '00000000-0000-0000-0000-000000000000' AS vm_guid, users_2.user_id, users_2.surname, users_2.domain,
                      users_2.username, users_2.groups, users_2.department, users_2.role as role, roles2.name AS mla_role, users_2.user_icon_path, users_2.desktop_device, users_2.email,
                      users_2.note, users_2.status, users_2.vm_admin, dbo.tags_user_group_map_view.tag_name, dbo.tags_user_group_map_view.tag_id,
                      users_2.session_count, pools1.vm_pool_name
FROM         dbo.vdc_users AS users_2 LEFT OUTER JOIN
                      dbo.users_and_groups_to_vm_pool_map_view AS pools1 ON users_2.user_id = pools1.user_id LEFT OUTER JOIN
                      dbo.permissions AS permissions_1 ON users_2.user_id = permissions_1.ad_element_id LEFT OUTER JOIN
                      dbo.tags AS tags_1 ON tags_1.type = 1 LEFT OUTER JOIN
                      dbo.tags_user_group_map_view ON users_2.user_id = dbo.tags_user_group_map_view.group_id LEFT OUTER JOIN
                      dbo.roles AS roles2 ON roles2.id = permissions_1.role_id
WHERE     (users_2.user_group = 'group')
GO

print 'Step 48 done.'
go



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vm_pools_view')
BEGIN
	EXEC('CREATE VIEW [vm_pools_view] AS SELECT 1 AS one')
END
GO

print 'Step 49 done.'
go

ALTER VIEW [vm_pools_view] AS
SELECT     dbo.vm_pools.vm_pool_id, dbo.vm_pools.vm_pool_name, dbo.vm_pools.vm_pool_description, dbo.vm_pools.vm_pool_type, 
                      dbo.vm_pools.parameters, dbo.vm_pools.vds_group_id, dbo.vds_groups.name AS vds_group_name
FROM         dbo.vm_pools INNER JOIN
                      dbo.vds_groups ON dbo.vm_pools.vds_group_id = dbo.vds_groups.vds_group_id
GO

print 'Step 50 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vm_pools_full_view')
BEGIN
	EXEC('CREATE VIEW [vm_pools_full_view] AS SELECT 1 AS one')
END
GO

print 'Step 51 done.'
go

ALTER VIEW [vm_pools_full_view] AS

SELECT     vm_pool_id, vm_pool_name, vm_pool_description, vm_pool_type, parameters, vds_group_id, vds_group_name,
              (SELECT     COUNT(vm_pool_map.vm_pool_id) AS Expr1
			   FROM	vm_pools_view AS v1 LEFT OUTER JOIN
                    vm_pool_map ON v1.vm_pool_id = vm_pool_map.vm_pool_id AND v1.vm_pool_id = vmp.vm_pool_id
			   ) AS assigned_vm_count,
              (SELECT     COUNT(v2.vm_pool_id) AS Expr1
               FROM	vm_pools AS v2 LEFT OUTER JOIN
                    vm_pool_map AS vm_pool_map_1 ON v2.vm_pool_id = vm_pool_map_1.vm_pool_id AND 
                    v2.vm_pool_id = vmp.vm_pool_id LEFT OUTER JOIN
                    vm_dynamic ON vm_pool_map_1.vm_guid = vm_dynamic.vm_guid
               WHERE vm_dynamic.status not in (0,15)
               GROUP BY v2.vm_pool_id) AS vm_running_count
FROM         vm_pools_view AS vmp
GO

print 'Step 52 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'permissions_view')
BEGIN
	EXEC('CREATE VIEW [permissions_view] AS SELECT 1 AS one')
END
GO

print 'Step 53 done.'
go

ALTER VIEW [permissions_view] AS

SELECT     dbo.permissions.id, dbo.permissions.role_id, dbo.permissions.ad_element_id, dbo.permissions.object_id, dbo.permissions.object_type_id, 
	       dbo.roles.name AS role_name, dbo.roles.role_type AS role_type, dbo.fn_get_entity_name(dbo.permissions.object_id, dbo.permissions.object_type_id) AS object_name,
			dbo.fn_get_ad_element_name(dbo.permissions.ad_element_id) as owner_name
FROM         dbo.permissions INNER JOIN
                      dbo.roles ON dbo.permissions.role_id = dbo.roles.id
GO

print 'Step 54 done.'
go


/*
SELECT     dbo.storages.id, dbo.storages.storage, dbo.storages.storage_pool_id, dbo.storages.storage_type, dbo.storage_pool.name, 
                      dbo.storage_pool.storage_pool_type
FROM         dbo.storage_pool INNER JOIN
                      dbo.storages ON dbo.storage_pool.id = dbo.storages.storage_pool_id
*/


/*************************************************
            DataWarehouse Views
            
IMPORTANT NOTE 
---------------
These views are used by the history ETL process, 
please do not change their scheme without touching 
base with Eli first !!!
*************************************************/

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_datacenter_configuration_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_datacenter_configuration_history_view AS SELECT 1 AS one')
END
GO

print 'Step 55 done.'
go


ALTER VIEW dbo.dwh_datacenter_configuration_history_view
AS
SELECT     	id AS datacenter_id, 
			name AS datacenter_name, 
			description AS datacenter_description, 
			cast(storage_pool_type as smallint) AS storage_type, 
			_create_date AS create_date, 
            _update_date AS update_date
FROM        dbo.storage_pool
WHERE     	(_create_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping
                           WHERE      (var_name = 'lastSync'))) OR
            (_update_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping AS history_timekeeping_1
                           WHERE      (var_name = 'lastSync')))
GO

print 'Step 56 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_datacenter_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_datacenter_history_view AS SELECT 1 AS one')
END
GO

print 'Step 57 done.'
go


ALTER VIEW dbo.dwh_datacenter_history_view AS 
SELECT
    id as datacenter_id,
	cast(status as smallint) as datacenter_status
FROM storage_pool
GO

print 'Step 58 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_storage_domain_configuration_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_storage_domain_configuration_history_view AS SELECT 1 AS one')
END
GO

print 'Step 59 done.'
go


ALTER VIEW dbo.dwh_storage_domain_configuration_history_view
AS
SELECT     	id AS storage_domain_id, 
			storage_name AS storage_domain_name, 
			cast(storage_domain_type as smallint) as storage_domain_type, 
			cast(storage_type as smallint) as storage_type, 
			_create_date AS create_date, 
            _update_date AS update_date
FROM        dbo.storage_domain_static
WHERE     (_create_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping
                           WHERE      (var_name = 'lastSync'))) OR
          (_update_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping AS history_timekeeping_1
                           WHERE      (var_name = 'lastSync')))
GO

print 'Step 60 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_datacenter_storage_map_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_datacenter_storage_map_history_view AS SELECT 1 AS one')
END
GO

print 'Step 61 done.'
go


ALTER VIEW dbo.dwh_datacenter_storage_map_history_view
AS
SELECT     	storage_pool_id AS datacenter_id, 
			storage_id AS storage_domain_id
FROM        dbo.storage_pool_iso_map
GO

print 'Step 62 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_storage_domain_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_storage_domain_history_view AS SELECT 1 AS one')
END
GO

print 'Step 63 done.'
go


ALTER VIEW dbo.dwh_storage_domain_history_view AS 
SELECT
	id as storage_domain_id,
	available_disk_size as available_disk_size_gb,
	used_disk_size as used_disk_size_gb
FROM storage_domain_dynamic
GO

print 'Step 64 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_cluster_configuration_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_cluster_configuration_history_view AS SELECT 1 AS one')
END
GO

print 'Step 65 done.'
go


ALTER VIEW dbo.dwh_cluster_configuration_history_view
AS
SELECT     	vds_group_id AS cluster_id, 
			name AS cluster_name, 
			description as cluster_description, 
			storage_pool_id AS datacenter_id,
			cpu_name,  
			compatibility_version, 
            _create_date AS create_date, 
			_update_date AS update_date
FROM        dbo.vds_groups
WHERE     (_create_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping
                           WHERE      (var_name = 'lastSync'))) OR
          (_update_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping AS history_timekeeping_1
                           WHERE      (var_name = 'lastSync')))
GO

print 'Step 66 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_host_configuration_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_host_configuration_history_view AS SELECT 1 AS one')
END
GO

print 'Step 67 done.'
go


ALTER VIEW dbo.dwh_host_configuration_history_view
AS
SELECT     	a.vds_id AS host_id, 
			a.vds_unique_id AS host_unique_id,
			a.vds_name AS host_name, 
			a.vds_group_id AS cluster_id, 
			cast(a.vds_type as smallint) AS host_type, 
			a.host_name AS fqn_or_ip, 
			b.physical_mem_mb AS memory_size_mb, 
			cast(c.swap_total as int) as swap_size_mb,
			b.cpu_model,  
			cast(b.cpu_cores as smallint) AS number_of_cores,
			b.host_os, 
			a.ip as pm_ip_address,
			b.kernel_version, 
			b.kvm_version, 
			b.software_version as vdsm_version, 
			a.port AS vdsm_port,
			a._create_date AS create_date, 
			a._update_date AS update_date
FROM        dbo.vds_static AS a 
			INNER JOIN
					dbo.vds_dynamic AS b ON a.vds_id = b.vds_id
			INNER JOIN
					dbo.vds_statistics AS c ON c.vds_id = a.vds_id
WHERE     (a._create_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping
                           WHERE      (var_name = 'lastSync'))) OR
          (a._update_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping AS history_timekeeping_1
                           WHERE      (var_name = 'lastSync')))
GO

print 'Step 68 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_host_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_host_history_view AS SELECT 1 AS one')
END
GO

print 'Step 69 done.'
go


ALTER VIEW dbo.dwh_host_history_view AS 
SELECT
	b.vds_id as host_id,
	cast(b.status as smallint) as host_status,
	cast(c.usage_mem_percent as smallint) as memory_usage_percent,
	cast(c.usage_cpu_percent as smallint) as cpu_usage_percent,
	cast(c.ksm_cpu_percent as smallint) as ksm_cpu_percent,
	cast(c.cpu_load as int) as cpu_load,
	cast(c.cpu_sys as smallint) as system_cpu_usage_percent,
	cast(c.cpu_user as smallint) as user_cpu_usage_percent,
	cast((c.swap_total - c.swap_free) as int) as swap_used_mb, 
	cast(b.vm_active as smallint) as vm_active,
	cast(b.vm_count as smallint) as total_vms,
	b.vms_cores_count as total_vms_vcpus
FROM vds_dynamic b, vds_statistics c
where	b.vds_id  = c.vds_id 
go

print 'Step 70 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_host_interface_configuration_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_host_interface_configuration_history_view AS SELECT 1 AS one')
END
GO

print 'Step 71 done.'
go


ALTER VIEW dbo.dwh_host_interface_configuration_history_view
AS
SELECT  a.id AS host_interface_id, 
		a.name AS host_interface_name, 
		a.vds_id AS host_id,
		cast(a.type as smallint) as host_interface_type,
		a.speed as host_interface_speed_bps,		
		a.mac_addr AS mac_address, 
		a.network_name, 
		a.addr AS ip_address,
		a.gateway, 
		a.is_bond AS bond, 
		a.bond_name, 
		cast(a.bond_type as smallint) as bond_type, 
		a.vlan_id, 
		a._create_date AS create_date, 
		a._update_date AS update_date
FROM         dbo.vds_interface as a
WHERE     ((a._create_date >
                          (SELECT     var_datetime
                            FROM          dbo.dwh_history_timekeeping
                            WHERE      (var_name = 'lastSync'))) OR
           (a._update_date >
                          (SELECT     var_datetime
                            FROM          dbo.dwh_history_timekeeping AS history_timekeeping_1
                            WHERE      (var_name = 'lastSync')))) AND
		   (a.is_bond is null OR 
		   (a.is_bond = 1 and a.name in(SELECT b.bond_name
									    FROM vds_interface AS b
									    where b.is_bond is null and b.vds_id = a.vds_id)))
GO

print 'Step 72 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_host_interface_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_host_interface_history_view AS SELECT 1 AS one')
END
GO

print 'Step 73 done.'
go


ALTER VIEW dbo.dwh_host_interface_history_view AS 
SELECT     vds_interface_statistics.id as host_interface_id, 
		   cast(vds_interface_statistics.rx_rate as smallint) as receive_rate_percent, 
		   cast(vds_interface_statistics.tx_rate as smallint) as transmit_rate_percent
FROM       dbo.vds_interface_statistics 
go

print 'Step 74 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_vm_configuration_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_vm_configuration_history_view AS SELECT 1 AS one')
END
GO

print 'Step 75 done.'
go


ALTER VIEW dbo.dwh_vm_configuration_history_view
AS
SELECT     	a.vm_guid AS vm_id, 
			a.vm_name, 
			a.description as vm_description, 
			cast(a.vm_type as smallint) as vm_type, 
			a.vds_group_id AS cluster_id, 
			a.vmt_guid AS template_id, 
            b.name AS template_name, 
			cast(a.cpu_per_socket as smallint) as cpu_per_socket, 
			cast(a.num_of_sockets as smallint) AS number_of_sockets, 
			a.mem_size_mb AS memory_size_mb, 
            cast(a.os as smallint) AS operating_system, 
			a.domain AS ad_domain, 
			a.dedicated_vm_for_vds AS default_host, 
			a.auto_startup AS high_availability, 
            a.is_initialized AS initialized, 
			a.is_stateless AS stateless, 
			a.fail_back, 
			a.is_auto_suspend AS auto_suspend, 
			cast(a.usb_policy as smallint) as usb_policy, 
			a.time_zone, 
			a._create_date AS create_date, 
            a._update_date AS update_date
FROM        dbo.vm_static as a INNER JOIN
                      dbo.vm_templates as b ON a.vmt_guid = b.vmt_guid
WHERE     (a._create_date >
                          (SELECT     var_datetime
                           FROM       dbo.dwh_history_timekeeping
                           WHERE      (var_name = 'lastSync'))) OR
          (a._update_date >
                          (SELECT     var_datetime
                           FROM       dbo.dwh_history_timekeeping AS history_timekeeping_1
                           WHERE      (var_name = 'lastSync')))

GO

print 'Step 76 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_vm_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_vm_history_view AS SELECT 1 AS one')
END
GO

print 'Step 77 done.'
go

  
ALTER VIEW dbo.dwh_vm_history_view AS 
SELECT
	c.vm_guid as vm_id,
	cast(b.status as smallint) as vm_status,
	cast(c.usage_cpu_percent as smallint) as cpu_usage_percent,
	cast(c.usage_mem_percent as smallint) as memory_usage_percent,
	cast(c.cpu_sys as smallint) as system_cpu_usage_percent,
	cast(c.cpu_user as smallint) as user_cpu_usage_percent,
	b.vm_last_up_time,
	b.vm_last_boot_time,
	b.vm_ip,
	b.guest_cur_user_name as current_user_name,
	b.run_on_vds as currently_running_on_host
FROM vm_dynamic b, vm_statistics c
where
	c.vm_guid = b.vm_guid
go

print 'Step 78 done.'
go



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_vm_interface_configuration_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_vm_interface_configuration_history_view AS SELECT 1 AS one')
END
GO

print 'Step 79 done.'
go


ALTER VIEW dbo.dwh_vm_interface_configuration_history_view
AS
SELECT     	id AS vm_interface_id, 
			name AS vm_interface_name, 
			vm_guid AS vm_id, 
			cast(type as smallint) as vm_interface_type, 
			speed as vm_interface_speed_bps,
			mac_addr AS mac_address, 
 			network_name, 
			_create_date AS create_date, 
            _update_date AS update_date
FROM         dbo.vm_interface
WHERE     (_create_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping
                           WHERE      (var_name = 'lastSync'))) OR
          (_update_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping AS history_timekeeping_1
                           WHERE      (var_name = 'lastSync')))
GO

print 'Step 80 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_vm_interface_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_vm_interface_history_view AS SELECT 1 AS one')
END
GO

print 'Step 81 done.'
go


ALTER VIEW dbo.dwh_vm_interface_history_view AS 
SELECT     dbo.vm_interface_statistics.id as vm_interface_id,  
		   cast(dbo.vm_interface_statistics.rx_rate as smallint) as receive_rate_percent, 
		   cast(dbo.vm_interface_statistics.tx_rate as smallint) as transmit_rate_percent
FROM       dbo.vm_interface_statistics 
GO

print 'Step 82 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_vm_disk_configuration_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_vm_disk_configuration_history_view AS SELECT 1 AS one')
END
GO

print 'Step 83 done.'
go


ALTER VIEW dbo.dwh_vm_disk_configuration_history_view
AS
SELECT     	image_guid AS vm_disk_id, 
			storage_id as storage_domain_id,
			cast(internal_drive_mapping as smallint) as vm_internal_drive_mapping, 
			description as vm_disk_description,
			cast(size / 1048576 as int) as vm_disk_size_mb,  
			cast(volume_type as smallint) AS vm_disk_type, 
			cast(volume_format as smallint) AS vm_disk_format, 
			cast(disk_interface as smallint) as vm_disk_interface,
			_create_date AS create_date, 
            _update_date AS update_date
FROM         dbo.images
WHERE     (_create_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping
                           WHERE      (var_name = 'lastSync'))) OR
          (_update_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping AS history_timekeeping_1
                           WHERE      (var_name = 'lastSync')))
GO

print 'Step 84 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_disk_vm_map_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_disk_vm_map_history_view AS SELECT 1 AS one')
END
GO

print 'Step 85 done.'
go


ALTER VIEW dbo.dwh_disk_vm_map_history_view
AS
SELECT image_id as vm_disk_id,
       vm_id
  FROM dbo.image_vm_map
WHERE active = 1
UNION ALL
SELECT  image_guid as vm_disk_id,
		vm_guid as vm_id
  FROM image_vm_pool_map
GO

print 'Step 86 done.'
go



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_vm_disks_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_vm_disks_history_view AS SELECT 1 AS one')
END
GO

print 'Step 87 done.'
go


ALTER VIEW dbo.dwh_vm_disks_history_view
AS
SELECT                
	images.image_guid as vm_disk_id, 
	cast(images.imageStatus as smallint) as vm_disk_status,  
	cast(disk_image_dynamic.actual_size / 1048576 as int) as vm_disk_actual_size_mb,
	disk_image_dynamic.read_rate as read_rate_bytes_per_second, 
	disk_image_dynamic.write_rate as write_rate_bytes_per_second
FROM    images 
			INNER JOIN
				disk_image_dynamic ON images.image_guid = disk_image_dynamic.image_id

GO

print 'Step 88 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_remove_tags_relations_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_remove_tags_relations_history_view AS SELECT 1 AS one')
END
GO

print 'Step 89 done.'
go


ALTER VIEW dbo.dwh_remove_tags_relations_history_view
AS
SELECT    tag_id as entity_id,
		  parent_id as parent_id
FROM      tags
UNION ALL
SELECT    vds_id as vds_id,
          tag_id as tag_id
FROM      tags_vds_map
UNION ALL
SELECT     vm_pool_id as vm_pool_id,
           tag_id as tag_id
FROM       tags_vm_pool_map 

UNION ALL
SELECT     vm_id as vm_id,
		   tag_id as tag_id
FROM       tags_vm_map 

UNION ALL
SELECT     user_id as user_id,
		   tag_id as tag_id
FROM       tags_user_map

UNION ALL
SELECT    group_id as group_id,
		  tag_id as tag_id
FROM      tags_user_group_map
GO

print 'Step 90 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_add_tags_relations_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_add_tags_relations_history_view AS SELECT 1 AS one')
END
GO

print 'Step 91 done.'
go


ALTER VIEW dbo.dwh_add_tags_relations_history_view
AS
SELECT    tag_id as entity_id,
		  parent_id as parent_id,
		  cast(18 as smallint) as entity_type,
		  _create_date as attach_date,
		  _update_date as move_date
FROM      tags
WHERE	  (_create_date >(SELECT     var_datetime as var_datetime
					      FROM          dwh_history_timekeeping
					      WHERE      (var_name = 'lastSync'))) OR
		  (_update_date >(SELECT     var_datetime as var_datetime
					   	  FROM       dwh_history_timekeeping AS history_timekeeping_1
						  WHERE      (var_name = 'lastSync')))
UNION ALL
SELECT    vds_id as vds_id,
          tag_id as tag_id,
          cast(3 as smallint),
		  _create_date,
		  null
FROM      tags_vds_map
WHERE	  _create_date >(SELECT     var_datetime as var_datetime
					      FROM          dwh_history_timekeeping
					      WHERE      (var_name = 'lastSync'))
UNION ALL
SELECT     vm_pool_id as vm_pool_id,
           tag_id as tag_id,
		   cast(5 as smallint),
		  _create_date,
		  null
FROM       tags_vm_pool_map 
WHERE	  _create_date >(SELECT     var_datetime as var_datetime
					      FROM          dwh_history_timekeeping
					      WHERE      (var_name = 'lastSync'))
UNION ALL
SELECT     vm_id as vm_id,
		   tag_id as tag_id,
		   cast(2 as smallint),
		  _create_date,
		  null
FROM       tags_vm_map 
WHERE	  _create_date >(SELECT     var_datetime as var_datetime
					      FROM          dwh_history_timekeeping
					      WHERE      (var_name = 'lastSync'))
UNION ALL
SELECT     user_id as user_id,
		   tag_id as tag_id,
		   cast(15 as smallint),
		  _create_date,
		  null
FROM       tags_user_map
WHERE	  _create_date >(SELECT     var_datetime as var_datetime
					      FROM          dwh_history_timekeeping
					      WHERE      (var_name = 'lastSync'))
UNION ALL
SELECT    group_id as group_id,
		  tag_id as tag_id,
		  cast(17 as smallint),
		  _create_date,
		  null
FROM      tags_user_group_map
WHERE	  _create_date >(SELECT     var_datetime as var_datetime
					      FROM          dwh_history_timekeeping
					      WHERE      (var_name = 'lastSync'))
GO

print 'Step 92 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'dwh_tags_details_history_view')
BEGIN
	EXEC('CREATE VIEW dbo.dwh_tags_details_history_view AS SELECT 1 AS one')
END
GO

print 'Step 93 done.'
go


ALTER VIEW dbo.dwh_tags_details_history_view
AS
SELECT     	tag_id, 
			tag_name, 
			description as tag_description, 
			_create_date as create_date, 
			_update_date as update_date
FROM       dbo.tags
WHERE     (_create_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping
                           WHERE      (var_name = 'lastSync'))) OR
          (_update_date >
                          (SELECT     var_datetime
                           FROM          dbo.dwh_history_timekeeping AS history_timekeeping_1
                           WHERE      (var_name = 'lastSync')))
GO

print 'Step 94 done.'
go


/*************************************************
            network view
*************************************************/
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'network_view')
BEGIN
	EXEC('CREATE VIEW dbo.[network_view] AS SELECT 1 AS one')
END
GO

print 'Step 95 done.'
go


ALTER VIEW [dbo].[network_view] AS 
SELECT  distinct   dbo.network.id, dbo.network.name, dbo.network.description, dbo.network.type, dbo.network.addr, dbo.network.subnet, dbo.network.gateway, 
                      dbo.network.vlan_id, dbo.network.stp, dbo.network.storage_pool_id, dbo.network_cluster.is_display, network_cluster.status
FROM         dbo.network LEFT OUTER JOIN
                      dbo.network_cluster ON dbo.network.id = dbo.network_cluster.network_id
GO

print 'Step 96 done.'
go



/*************************************************
            interface view
*************************************************/
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'interface_view')
BEGIN
	EXEC('CREATE VIEW dbo.[interface_view] AS SELECT 1 AS one')
END
GO

print 'Step 97 done.'
go

ALTER VIEW [dbo].[interface_view] AS
SELECT  dbo.vds_interface_statistics.rx_rate, 
        dbo.vds_interface_statistics.tx_rate, 
        dbo.vds_interface_statistics.rx_drop, 
        dbo.vds_interface_statistics.tx_drop, 
        dbo.vds_interface_statistics.iface_status, 
        dbo.vds_interface.type, 
        dbo.vds_interface.gateway,
        dbo.vds_interface.subnet,
        dbo.vds_interface.addr,
        dbo.vds_interface.speed, 
        dbo.vds_interface.vlan_id,
        dbo.vds_interface.bond_type,
        dbo.vds_interface.bond_name,        
        dbo.vds_interface.is_bond,
		dbo.vds_interface.bond_opts,
        dbo.vds_interface.mac_addr, 
        dbo.vds_interface.network_name,
        dbo.vds_interface.name,
        dbo.vds_static.vds_id,
        dbo.vds_static.vds_name,
        null as vm_guid ,
        null as vmt_guid ,
        null as vm_name,
        dbo.vds_interface.id,
        dbo.vds_interface.boot_protocol as boot_protocol,
        1 as is_vds
FROM    dbo.vds_interface_statistics 
        INNER JOIN 
        dbo.vds_interface ON dbo.vds_interface_statistics.id = dbo.vds_interface.id 
        INNER JOIN
        dbo.vds_static ON dbo.vds_interface.vds_id = dbo.vds_static.vds_id 

UNION
SELECT  dbo.vm_interface_statistics.rx_rate, 
        dbo.vm_interface_statistics.tx_rate, 
        dbo.vm_interface_statistics.rx_drop, 
        dbo.vm_interface_statistics.tx_drop, 
        dbo.vm_interface_statistics.iface_status, 
        dbo.vm_interface.type as type , 
        null as gateway ,
        null as subnet ,
        null as addr ,
        dbo.vm_interface.speed, 
        null as vlan_id ,
        null as bond_type ,
        null as bond_name ,
        null as is_bond ,
		null as bond_opts ,
        mac_addr, 
        dbo.vm_interface.network_name,
        dbo.vm_interface.name,
        null as vds_id ,
        null as vds_name ,
        dbo.vm_static.vm_guid,
        dbo.vm_interface.vmt_guid,
        dbo.vm_static.vm_name,
		dbo.vm_interface.id,
        0 as boot_protocol,
        0 as is_vds
FROM    dbo.vm_interface_statistics 
        INNER JOIN 
        dbo.vm_interface ON dbo.vm_interface_statistics.id = dbo.vm_interface.id 
        INNER JOIN
        dbo.vm_static ON dbo.vm_interface.vm_guid = dbo.vm_static.vm_guid
UNION
SELECT  dbo.vm_interface_statistics.rx_rate, 
        dbo.vm_interface_statistics.tx_rate, 
        dbo.vm_interface_statistics.rx_drop, 
        dbo.vm_interface_statistics.tx_drop, 
        dbo.vm_interface_statistics.iface_status, 
        dbo.vm_interface.type as type , 
        null as gateway ,
        null as subnet ,
        null as addr ,
        dbo.vm_interface.speed, 
        null as vlan_id ,
        null as bond_type ,
        null as bond_name ,
        null as is_bond ,
		null as bond_opts ,
        mac_addr, 
        dbo.vm_interface.network_name,
        dbo.vm_interface.name,
        null as vds_id ,
        null as vds_name ,
        null as vm_guid,
        dbo.vm_interface.vmt_guid,
        dbo.vm_templates.[name],
		dbo.vm_interface.id,
        0 as boot_protocol,
        0 as is_vds
FROM    dbo.vm_interface_statistics 
        RIGHT JOIN 
        dbo.vm_interface ON dbo.vm_interface_statistics.id = dbo.vm_interface.id 
        INNER JOIN
        dbo.vm_templates ON dbo.vm_interface.vmt_guid = dbo.vm_templates.vmt_guid
GO

print 'Step 98 done.'
go


/*--------------------------------------------*/
/* Event Notification Views                     */
/*--------------------------------------------*/

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'event_audit_log_subscriber_view')
BEGIN
	EXEC('CREATE VIEW dbo.[event_audit_log_subscriber_view] AS SELECT 1 AS one')
END
GO

print 'Step 99 done.'
go


ALTER VIEW [dbo].[event_audit_log_subscriber_view]
AS
SELECT     1 AS event_type, event_subscriber_1.subscriber_id, event_subscriber_1.event_up_name, event_subscriber_1.method_id, 
                      event_subscriber_1.method_address, event_subscriber_1.tag_name, audit_log_1.audit_log_id, audit_log_1.user_id, audit_log_1.user_name, 
                      audit_log_1.vm_id, audit_log_1.vm_name, audit_log_1.vm_template_id, audit_log_1.vm_template_name, audit_log_1.vds_id, audit_log_1.vds_name, 
                      audit_log_1.storage_pool_id, audit_log_1.storage_pool_name, audit_log_1.storage_domain_id, audit_log_1.storage_domain_name, 
                      audit_log_1.log_time, audit_log_1.severity, audit_log_1.message
FROM         dbo.audit_log AS audit_log_1 INNER JOIN
                      dbo.event_subscriber AS event_subscriber_1 ON audit_log_1.log_type_name = event_subscriber_1.event_up_name
WHERE     (audit_log_1.processed = 0)
UNION
SELECT     0 AS event_type, event_subscriber.subscriber_id, event_subscriber.event_up_name, event_subscriber.method_id, event_subscriber.method_address, 
                      event_subscriber.tag_name, audit_log.audit_log_id, audit_log.user_id, audit_log.user_name, audit_log.vm_id, audit_log.vm_name, 
                      audit_log.vm_template_id, audit_log.vm_template_name, audit_log.vds_id, audit_log.vds_name, audit_log.storage_pool_id, 
                      audit_log.storage_pool_name, audit_log.storage_domain_id, audit_log.storage_domain_name, audit_log.log_time, audit_log.severity, 
                      audit_log.message
FROM         dbo.audit_log AS audit_log INNER JOIN
                      dbo.event_map ON audit_log.log_type_name = dbo.event_map.event_down_name INNER JOIN
                      dbo.event_subscriber AS event_subscriber ON event_subscriber.event_up_name = dbo.event_map.event_up_name
WHERE     (audit_log.processed = 0)
GO

print 'Step 100 done.'
go


IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'event_subscriber_notification_methods_view')
BEGIN
	EXEC('CREATE VIEW dbo.[event_subscriber_notification_methods_view] AS SELECT 1 AS one')
END
GO

print 'Step 101 done.'
go


ALTER VIEW [dbo].[event_subscriber_notification_methods_view]
AS
SELECT     dbo.event_subscriber.subscriber_id, dbo.event_subscriber.event_up_name, dbo.event_notification_methods.method_type
FROM         dbo.event_notification_methods INNER JOIN
                      dbo.event_subscriber ON dbo.event_notification_methods.method_id = dbo.event_subscriber.method_id

GO

print 'Step 102 done.'
go


/*--------------------------------------------*/
/* Storage Pool                               */
/*--------------------------------------------*/

IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'storage_pool_with_storage_domain')
BEGIN
	EXEC('CREATE VIEW dbo.[storage_pool_with_storage_domain] AS SELECT 1 AS one')
END
GO

print 'Step 103 done.'
go


ALTER VIEW [dbo].[storage_pool_with_storage_domain]
AS
SELECT     dbo.storage_pool.id, dbo.storage_pool.name, dbo.storage_pool.description, dbo.storage_pool.storage_pool_type, dbo.storage_pool.status, 
                      dbo.storage_pool.master_domain_version, dbo.storage_pool.spm_vds_id, dbo.storage_pool.compatibility_version, dbo.storage_pool._create_date, 
                      dbo.storage_pool._update_date, dbo.storage_pool_iso_map.storage_id, dbo.storage_pool_iso_map.storage_pool_id, 
                      dbo.storage_pool_iso_map.owner, dbo.storage_domain_static.storage_type, dbo.storage_domain_static.storage_domain_type, 
					  dbo.storage_domain_static.storage_domain_format_type,
                      dbo.storage_domain_static.storage_name, dbo.storage_domain_static.storage
FROM         dbo.storage_pool LEFT OUTER JOIN
                      dbo.storage_pool_iso_map ON dbo.storage_pool.id = dbo.storage_pool_iso_map.storage_pool_id LEFT OUTER JOIN
                      dbo.storage_domain_static ON dbo.storage_pool_iso_map.storage_id = dbo.storage_domain_static.id
GO

print 'Step 104 done.'
go



/*--------------------------------------------*/
/* Clusters                                   */
/*--------------------------------------------*/
IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'vds_groups_storage_domain')
BEGIN
	EXEC('CREATE VIEW dbo.[vds_groups_storage_domain] AS SELECT 1 AS one')
END
GO

print 'Step 105 done.'
go


ALTER VIEW [dbo].[vds_groups_storage_domain]
AS
SELECT     dbo.vds_groups.vds_group_id, dbo.vds_groups.name, dbo.vds_groups.description, dbo.vds_groups.cpu_name, dbo.vds_groups._create_date,
                      dbo.vds_groups._update_date, dbo.vds_groups.selection_algorithm, dbo.vds_groups.high_utilization, dbo.vds_groups.low_utilization,
                      dbo.vds_groups.cpu_over_commit_duration_minutes, dbo.vds_groups.hypervisor_type, dbo.vds_groups.storage_pool_id,
                      dbo.vds_groups.max_vds_memory_over_commit, dbo.vds_groups.compatibility_version,
                      dbo.vds_groups.transparent_hugepages, dbo.vds_groups.migrate_on_error,dbo.storage_pool_iso_map.storage_id
FROM         dbo.vds_groups LEFT JOIN
                      dbo.storage_pool_iso_map ON dbo.vds_groups.storage_pool_id = dbo.storage_pool_iso_map.storage_pool_id
GO

print 'Step 106 done.'
go



IF NOT EXISTS (SELECT NAME FROM sys.objects WHERE TYPE = 'V' AND NAME = 'storage_domains_with_hosts_view')
BEGIN
	EXEC('CREATE VIEW dbo.[storage_domains_with_hosts_view] AS SELECT 1 AS one')
END
GO

print 'Step 107 done.'
go


ALTER VIEW [dbo].[storage_domains_with_hosts_view] AS
SELECT
		dbo.storage_domain_static.id,
		dbo.storage_domain_static.storage,
		dbo.storage_domain_static.storage_name,
		dbo.storage_domain_dynamic.available_disk_size,
		dbo.storage_domain_dynamic.used_disk_size,
		dbo.fn_get_disk_commited_value_by_storage(dbo.storage_domain_static.id) as [commited_disk_size],
		dbo.storage_pool.name as storage_pool_name,
		dbo.storage_domain_static.storage_type,
		dbo.storage_domain_static.storage_domain_type,
		dbo.storage_domain_static.storage_domain_format_type,
        dbo.fn_get_storage_domain_shared_status_by_domain_id(dbo.storage_domain_static.id, dbo.storage_domain_static.storage,
														dbo.storage_domain_static.storage_type) AS storage_domain_shared_status,
		dbo.vds_groups.vds_group_id,
		dbo.vds_static.vds_id,
		dbo.storage_pool_iso_map.storage_pool_id
FROM    dbo.storage_domain_static
		INNER JOIN dbo.storage_domain_dynamic ON dbo.storage_domain_static.id = dbo.storage_domain_dynamic.id
		LEFT OUTER JOIN dbo.storage_pool_iso_map ON dbo.storage_domain_static.id = dbo.storage_pool_iso_map.storage_id
		LEFT OUTER JOIN dbo.storage_pool ON dbo.storage_pool_iso_map.storage_pool_id = dbo.storage_pool.id
		LEFT OUTER JOIN dbo.vds_groups ON dbo.storage_pool_iso_map.storage_pool_id = dbo.vds_groups.storage_pool_id
		LEFT OUTER JOIN dbo.vds_static ON dbo.vds_groups.vds_group_id = dbo.vds_static.vds_group_id

GO

print 'Step 108 done.'
go


