
#include "pch.h"

#include <cstdlib>
#include <iostream>

#include <boost/program_options.hpp>

#include "application.h"

int main(int argc, char *argv[])
{
    Application app;

#ifdef WIN32
    WSADATA wsa;
    ::WSAStartup(MAKEWORD(2,2), &wsa);
#endif

    std::vector<std::string> args;
    std::ostringstream cmdline;
    
    args.reserve(argc);
    for (int i = 1; i < argc; ++i) {
        if (strlen(argv[i]) > 0) {
            args.push_back(argv[i]);
            cmdline << " " << argv[i];
        }
    }

    try
    {
        LOG_DEBUG(cmdline.str().c_str());
        if (app.parse_command_line(args)) {
            app.execute();
        }
    }
    catch (const std::exception& e)
    {
        LOG_ERROR("Unhandled exception: " << e.what());
    }

    return EXIT_SUCCESS;
}
