%global checkout 20130109git

Summary: Basic networking tools
Name: net-tools
Version: 2.0
%define base_release .5
Release: 0.6.%{checkout}%{?dist}%{?base_release}
License: GPLv2+
Group: System Environment/Base
URL: http://sourceforge.net/projects/net-tools/

# git archive --format=tar --remote=git://net-tools.git.sourceforge.net/gitroot/net-tools/net-tools master | xz > net-tools-%%{version}.%%{checkout}.tar.xz
Source0: net-tools-%{version}.%{checkout}.tar.xz
Source1: net-tools-config.h
Source2: net-tools-config.make
Source3: ether-wake.c
Source4: ether-wake.8
Source5: mii-diag.c
Source6: mii-diag.8
Source7: iptunnel.8
Source8: ipmaddr.8
Source9: arp-ethers.service
Source999: fivextra.tar.bz2

# adds <delay> option that allows netstat to cycle printing through statistics every delay seconds.
Patch1: net-tools-cycle.patch

# Fixed incorrect address display for ipx (#46434)
Patch2: net-tools-ipx.patch

# hostname lookup problems with route --inet6 (#84108)
Patch3: net-tools-inet6-lookup.patch

# various man page fixes merged into one patch
Patch4: net-tools-man.patch

# netstat: interface option now works as described in the man page (#61113, #115987)
Patch5: net-tools-interface.patch

# filter out duplicate tcp entries (#139407)
Patch6: net-tools-duplicate-tcp.patch

# don't report statistics for virtual devices (#143981)
Patch7: net-tools-statalias.patch

# clear static buffers in interface.c by Ulrich Drepper (#176714)
Patch8: net-tools-interface_stack.patch

# statistics for SCTP
Patch9: net-tools-sctp-statistics.patch

# ifconfig crash when interface name is too long (#190703)
Patch10: net-tools-ifconfig-long-iface-crasher.patch

# fixed tcp timers info in netstat (#466845)
Patch11: net-tools-netstat-probe.patch

BuildRequires: gettext, libselinux
BuildRequires: libselinux-devel
BuildRequires: systemd-units
Requires(post): systemd-units

%description
The net-tools package contains basic networking tools,
including ifconfig, netstat, route, and others.
Most of them are obsolete. For replacement check iproute package.

%package fivextra
Summary: Test for %{name} package
Group:  fivextra
Prefix: /opt/fiv/ltp
Requires: hostname
Requires: traceroute

%description fivextra
This package contains testcases for %{name}.

%prep
%setup -q -c -a 999
%patch1 -p1 -b .cycle
%patch2 -p1 -b .ipx
%patch3 -p1 -b .inet6-lookup
%patch4 -p1 -b .man
%patch5 -p1 -b .interface
%patch6 -p1 -b .dup-tcp
%patch7 -p1 -b .statalias
%patch8 -p1 -b .stack
%patch9 -p1 -b .sctp
%patch10 -p1 -b .long_iface
%patch11 -p1 -b .probe

cp %SOURCE1 ./config.h
cp %SOURCE2 ./config.make
cp %SOURCE3 .
cp %SOURCE4 ./man/en_US
cp %SOURCE5 .
cp %SOURCE6 ./man/en_US
cp %SOURCE7 ./man/en_US
cp %SOURCE8 ./man/en_US

%ifarch alpha
perl -pi -e "s|-O2||" Makefile
%endif

%build
# Sparc and s390 arches need to use -fPIE
%ifarch sparcv9 sparc64 s390 s390x
export CFLAGS="$RPM_OPT_FLAGS $CFLAGS -fPIE"
%else
export CFLAGS="$RPM_OPT_FLAGS $CFLAGS -fpie"
%endif
# RHBZ #853193
export LDFLAGS="$LDFLAGS -pie -Wl,-z,relro -Wl,-z,now"
export CC=%{__cc}

make
%{__cc} $RPM_OPT_FLAGS -o ether-wake ether-wake.c
%{__cc} $RPM_OPT_FLAGS -o mii-diag mii-diag.c

pushd fivextra
make all
popd

%install
mv man/de_DE man/de
mv man/fr_FR man/fr
mv man/pt_BR man/pt

make BASEDIR=%{buildroot} mandir=%{_mandir} install

# ifconfig and route are installed into /bin by default
# mv them back to /sbin for now as I (jpopelka) don't think customers would be happy
mv %{buildroot}/bin/ifconfig %{buildroot}/sbin
mv %{buildroot}/bin/route %{buildroot}/sbin

install -m 755 ether-wake %{buildroot}/sbin
install -m 755 mii-diag %{buildroot}/sbin

rm %{buildroot}/sbin/rarp
rm %{buildroot}%{_mandir}/man8/rarp.8*
rm %{buildroot}%{_mandir}/de/man8/rarp.8*
rm %{buildroot}%{_mandir}/fr/man8/rarp.8*
rm %{buildroot}%{_mandir}/pt/man8/rarp.8*

# remove hostname (has its own package)
rm %{buildroot}/bin/dnsdomainname
rm %{buildroot}/bin/domainname
rm %{buildroot}/bin/hostname
rm %{buildroot}/bin/nisdomainname
rm %{buildroot}/bin/ypdomainname
rm -rf %{buildroot}%{_mandir}/de/man1
rm -rf %{buildroot}%{_mandir}/fr/man1
rm -rf %{buildroot}%{_mandir}/man1
rm -rf %{buildroot}%{_mandir}/pt/man1

# install systemd unit file
mkdir -p %{buildroot}%{_unitdir}
install -m 644 %{SOURCE9} %{buildroot}%{_unitdir}

# Steps to package the net-tools tests for FIV
for dir in `cd fivextra; find . -type d -not -name CVS`
do
       install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
       install -m 755 `find fivextra/$dir/* -type d -prune -o -print`  $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done 
find $RPM_BUILD_ROOT/%{fivdir}/%{name} -depth -name CVS -type d -exec rm -rf {} \;

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%find_lang %{name} --all-name --with-man

%post
%systemd_post arp-ethers.service

%files -f %{name}.lang
%doc COPYING
/bin/netstat
/sbin/ifconfig
/sbin/route
/sbin/arp
/sbin/ether-wake
/sbin/ipmaddr
/sbin/iptunnel
/sbin/mii-diag
/sbin/mii-tool
/sbin/nameif
/sbin/plipconfig
/sbin/slattach
%{_mandir}/man[58]/*
%attr(0644,root,root)   %{_unitdir}/arp-ethers.service

%files fivextra
%{prefix}

%changelog
* Mon May 13 2013 baseuser@ibm.com
- Base-8.x spec file
