Summary: Library for error values used by GnuPG components
Name: libgpg-error
Version: 1.11
%define base_release .4
Release: 1%{?dist}%{?base_release}
URL: ftp://ftp.gnupg.org/gcrypt/libgpg-error/
Source0: ftp://ftp.gnupg.org/gcrypt/libgpg-error/%{name}-%{version}.tar.bz2
Source1: ftp://ftp.gnupg.org/gcrypt/libgpg-error/%{name}-%{version}.tar.bz2.sig
Source999: fivextra.tar.bz2 
Group: System Environment/Libraries
License: LGPLv2+
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: gawk, gettext, autoconf, automake, gettext-devel, libtool
%if 0%{?fedora} > 13
BuildRequires: gettext-autopoint
%endif
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig

%description
This is a library that defines common error values for all GnuPG
components.  Among these are GPG, GPGSM, GPGME, GPG-Agent, libgcrypt,
pinentry, SmartCard Daemon and possibly more in the future.

%package devel
Summary: Development files for the %{name} package
Group: Development/Libraries
Requires: %{name}%{?_isa} = %{version}-%{release}

%description devel
This is a library that defines common error values for all GnuPG
components.  Among these are GPG, GPGSM, GPGME, GPG-Agent, libgcrypt,
pinentry, SmartCard Daemon and possibly more in the future. This package
contains files necessary to develop applications using libgpg-error.

%package fivextra
Summary: Tests for FIV
Group: fivextra
Prefix: /opt/fiv/ltp

%description fivextra
This package contains the testcases built from the package for %{name}. 

%prep
%setup -q -a 999 
# The config script already suppresses the -L if it's /usr/lib, so cheat and
# set it to a value which we know will be suppressed.
sed -i -e 's|^libdir=@libdir@$|libdir=@exec_prefix@/lib|g;s|@GPG_ERROR_CONFIG_HOST@|none|g' src/gpg-error-config.in

# We need a version of libtool that won't decide to add an rpath of /usr/lib64
# even when we ask it not to.
autoreconf -f -i

%build
%configure --disable-static --disable-rpath --disable-languages
make %{?_smp_mflags}

pushd fivextra
make all
popd 

%install
rm -fr $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT
rm -f $RPM_BUILD_ROOT/%{_libdir}/*.la

%find_lang %{name}

# Relocate the shared libraries to /%{_lib}.
mkdir -p $RPM_BUILD_ROOT/%{_lib}
for shlib in $RPM_BUILD_ROOT/%{_libdir}/*.so* ; do
	if test -L "$shlib" ; then
		rm "$shlib"
	else
		mv "$shlib" $RPM_BUILD_ROOT/%{_lib}/
	fi
done
# Figure out where /%{_lib} is relative to %{_libdir}.
touch $RPM_BUILD_ROOT/root_marker
relroot=..
while ! test -f $RPM_BUILD_ROOT/%{_libdir}/$relroot/root_marker ; do
	relroot=$relroot/..
done
# Overwrite development symlinks.
pushd $RPM_BUILD_ROOT/%{_libdir}
for shlib in $relroot/%{_lib}/lib*.so.* ; do
	shlib=`echo "$shlib" | sed -e 's,//,/,g'`
	target=`basename "$shlib" | sed -e 's,\.so.*,,g'`.so
	ln -sf $shlib $target
done
popd
# Add the soname symlink.
%if ! 0%{?cross_build}
  /sbin/ldconfig -n $RPM_BUILD_ROOT/%{_lib}
%else
for i in $RPM_BUILD_ROOT/%{_lib}/*; do
  ln -sf ${i##*/} ${i%.*.*}
done
%endif

rm -f $RPM_BUILD_ROOT/root_marker

mkdir -p $RPM_BUILD_ROOT/%{fivdir}/%{name}
cp -a tests $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/
# The test executables are in .libs/ . copy the over to the right place
# And delete unnecessary files
( cd $RPM_BUILD_ROOT/%{fivdir}/%{name}/%{name}-tests/ ; \
        mv .libs/t* . ; \
        rm -rf *.o *.am *.in .deps .libs )

for dir in `cd fivextra; find . -type d -not -name CVS`
do
  install -d $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
  install -m 755 `find fivextra/$dir/* -type d -prune -o -print` $RPM_BUILD_ROOT/%{fivdir}/%{name}/$dir
done

install -d $RPM_BUILD_ROOT/%{prefix}/testcases/bin
pushd $RPM_BUILD_ROOT/%{fivdir}/%{name}
make install
popd

%check
make check

%clean
rm -fr $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -f %{name}.lang
%defattr(-,root,root)
%doc COPYING COPYING.LIB AUTHORS README NEWS ChangeLog
%{_bindir}/gpg-error
/%{_lib}/libgpg-error.so.0*

%files devel
%defattr(-,root,root)
%{_bindir}/gpg-error-config
%{_libdir}/libgpg-error.so
%{_includedir}/gpg-error.h
%{_datadir}/aclocal/gpg-error.m4

%files fivextra
%defattr(-,root,root)
%{prefix} 

%changelog
* Wed Jun 05 2013 baseuser@ibm.com
- Base-8.x spec file
